/*
 * Decompiled with CFR 0.152.
 */
package gr.ekt.bteio.loaders;

import gr.ekt.bte.core.DataLoadingSpec;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.RecordSet;
import gr.ekt.bte.dataloader.FileDataLoader;
import gr.ekt.bte.record.XPathRecord;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLDirectoryDataLoader
extends FileDataLoader {
    private Map<String, String> xpathStringMap_;
    private static Logger logger = Logger.getLogger(XMLDirectoryDataLoader.class);

    public XMLDirectoryDataLoader(String filename, Map<String, String> xpath_string_map) {
        super(filename);
        this.xpathStringMap_ = xpath_string_map;
    }

    public RecordSet getRecords() {
        RecordSet ret = new RecordSet();
        File data_dir = new File(this.filename);
        if (!data_dir.isDirectory()) {
            return null;
        }
        File[] xmls = data_dir.listFiles(new XmlFilter());
        DocumentBuilderFactory doc_factory = DocumentBuilderFactory.newInstance();
        doc_factory.setNamespaceAware(true);
        try {
            DocumentBuilder doc_builder = doc_factory.newDocumentBuilder();
            for (File fl : xmls) {
                try {
                    Document doc = doc_builder.parse(fl);
                    XPathRecord rec = new XPathRecord(doc, this.xpathStringMap_);
                    ret.addRecord((Record)rec);
                }
                catch (SAXException e) {
                    logger.info((Object)e.getStackTrace());
                }
                catch (IOException e) {
                    logger.info((Object)e.getStackTrace());
                }
                catch (XPathExpressionException e) {
                    logger.info((Object)e.getStackTrace());
                }
            }
        }
        catch (ParserConfigurationException e) {
            logger.info((Object)e.getStackTrace());
            return null;
        }
        return ret;
    }

    public RecordSet getRecords(DataLoadingSpec spec) {
        return this.getRecords();
    }

    class XmlFilter
    implements FilenameFilter {
        XmlFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".xml");
        }
    }
}

