/*
 * Decompiled with CFR 0.152.
 */
package gr.grnet.pithosj.core;

import com.twitter.io.Buf;
import com.twitter.logging.Logger$;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import gr.grnet.common.io.BufHelpers$;
import gr.grnet.pithosj.api.PithosApi$;
import gr.grnet.pithosj.core.PithosApiSkeleton;
import gr.grnet.pithosj.core.ServiceInfo;
import gr.grnet.pithosj.core.command.CheckExistsObjectCommand;
import gr.grnet.pithosj.core.command.CheckExistsObjectCommand$;
import gr.grnet.pithosj.core.command.CopyObjectCommand;
import gr.grnet.pithosj.core.command.CreateDirectoryCommand;
import gr.grnet.pithosj.core.command.DeleteDirectoryCommand;
import gr.grnet.pithosj.core.command.DeleteDirectoryCommand$;
import gr.grnet.pithosj.core.command.DeleteFileCommand;
import gr.grnet.pithosj.core.command.GetAccountInfoCommand;
import gr.grnet.pithosj.core.command.GetObject2Command;
import gr.grnet.pithosj.core.command.GetObjectCommand;
import gr.grnet.pithosj.core.command.GetObjectInfoCommand;
import gr.grnet.pithosj.core.command.ListContainersCommand;
import gr.grnet.pithosj.core.command.ListObjectsInPathCommand;
import gr.grnet.pithosj.core.command.PingCommand;
import gr.grnet.pithosj.core.command.PithosCommand;
import gr.grnet.pithosj.core.command.PutObjectCommand;
import java.io.File;
import java.io.OutputStream;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.Nothing$;
import typedkey.env.immutable.Env;

public abstract class PithosApiSkeleton$class {
    public static Future call(PithosApiSkeleton $this, PithosCommand command) {
        Future future;
        try {
            Future future2;
            Option option = command.validate();
            if (option instanceof Some) {
                Some some = (Some)option;
                String error = (String)some.x();
                String name = command.commandName();
                future2 = Future$.MODULE$.rawException((Throwable)new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not validate ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, error}))));
            } else if (None$.MODULE$.equals(option)) {
                future2 = $this.callImpl(command);
            } else {
                throw new MatchError((Object)option);
            }
            future = future2;
        }
        catch (Throwable throwable) {
            future = Future$.MODULE$.rawException((Throwable)new RuntimeException("Internal error", throwable));
        }
        return future;
    }

    public static Future ping(PithosApiSkeleton $this, ServiceInfo serviceInfo) {
        return $this.call(new PingCommand(serviceInfo));
    }

    public static Future getAccountInfo(PithosApiSkeleton $this, ServiceInfo serviceInfo) {
        return $this.call(new GetAccountInfoCommand(serviceInfo));
    }

    public static Nothing$ replaceAccountMeta(PithosApiSkeleton $this, ServiceInfo serviceInfo, Env meta) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public static Nothing$ deleteAccountMeta(PithosApiSkeleton $this, ServiceInfo serviceInfo, String metaKey) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public static Future listContainers(PithosApiSkeleton $this, ServiceInfo serviceInfo) {
        return $this.call(new ListContainersCommand(serviceInfo));
    }

    public static Nothing$ createContainer(PithosApiSkeleton $this, ServiceInfo serviceInfo, String container) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public static Nothing$ getContainerInfo(PithosApiSkeleton $this, ServiceInfo serviceInfo, String container) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public static Nothing$ deleteContainer(PithosApiSkeleton $this, ServiceInfo serviceInfo, String container) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public static Future createDirectory(PithosApiSkeleton $this, ServiceInfo serviceInfo, String _container, String _path) {
        Tuple2<String, String> tuple2 = PithosApi$.MODULE$.containerAndPath(_container, PithosApi$.MODULE$.normalizeDirectoryPath(_path));
        if (tuple2 != null) {
            Tuple2 tuple22;
            String container = (String)tuple2._1();
            String path = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)container, (Object)path);
            String container2 = (String)tuple23._1();
            String path2 = (String)tuple23._2();
            return $this.call(new CreateDirectoryCommand(serviceInfo, container2, path2));
        }
        throw new MatchError(tuple2);
    }

    public static Nothing$ getObjectMeta(PithosApiSkeleton $this, ServiceInfo serviceInfo, String path) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public static Nothing$ deleteObjectMeta(PithosApiSkeleton $this, ServiceInfo serviceInfo, String path, String metaKey) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public static Nothing$ replaceObjectMeta(PithosApiSkeleton $this, ServiceInfo serviceInfo, String path, Env meta) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public static Future getObject(PithosApiSkeleton $this, ServiceInfo serviceInfo, String _container, String _path, String version, OutputStream out) {
        Tuple2<String, String> tuple2 = PithosApi$.MODULE$.containerAndPath(_container, PithosApi$.MODULE$.normalizeDirectoryPath(_path));
        if (tuple2 != null) {
            Tuple2 tuple22;
            String container = (String)tuple2._1();
            String path = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)container, (Object)path);
            String container2 = (String)tuple23._1();
            String path2 = (String)tuple23._2();
            return $this.call(new GetObjectCommand(serviceInfo, container2, path2, version, out));
        }
        throw new MatchError(tuple2);
    }

    public static Future getObject2(PithosApiSkeleton $this, ServiceInfo serviceInfo, String _container, String _path, String version) {
        Tuple2<String, String> tuple2 = PithosApi$.MODULE$.containerAndPath(_container, PithosApi$.MODULE$.normalizeDirectoryPath(_path));
        if (tuple2 != null) {
            Tuple2 tuple22;
            String container = (String)tuple2._1();
            String path = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)container, (Object)path);
            String container2 = (String)tuple23._1();
            String path2 = (String)tuple23._2();
            return $this.call(new GetObject2Command(serviceInfo, container2, path2, version));
        }
        throw new MatchError(tuple2);
    }

    public static Future getObjectInfo(PithosApiSkeleton $this, ServiceInfo serviceInfo, String _container, String _path) {
        Tuple2<String, String> tuple2 = PithosApi$.MODULE$.containerAndPath(_container, PithosApi$.MODULE$.normalizeDirectoryPath(_path));
        if (tuple2 != null) {
            Tuple2 tuple22;
            String container = (String)tuple2._1();
            String path = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)container, (Object)path);
            String container2 = (String)tuple23._1();
            String path2 = (String)tuple23._2();
            return $this.call(new GetObjectInfoCommand(serviceInfo, container2, path2));
        }
        throw new MatchError(tuple2);
    }

    public static Future putObject(PithosApiSkeleton $this, ServiceInfo serviceInfo, String _container, String _path, File file, String _contentType) {
        Tuple2<String, String> tuple2 = PithosApi$.MODULE$.containerAndPath(_container, PithosApi$.MODULE$.normalizeDirectoryPath(_path));
        if (tuple2 != null) {
            Tuple2 tuple22;
            String container = (String)tuple2._1();
            String path = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)container, (Object)path);
            String container2 = (String)tuple23._1();
            String path2 = (String)tuple23._2();
            String string = _contentType;
            boolean bl = string == null ? true : "".equals(string);
            String string2 = bl ? PithosApi$.MODULE$.guessContentTypeFromPath(path2) : _contentType;
            String contentType = string2;
            return $this.call(new PutObjectCommand(serviceInfo, container2, path2, BufHelpers$.MODULE$.bufOfFile(file), contentType));
        }
        throw new MatchError(tuple2);
    }

    public static Future putObject(PithosApiSkeleton $this, ServiceInfo serviceInfo, String _container, String _path, byte[] bytes, String _contentType) {
        Tuple2<String, String> tuple2 = PithosApi$.MODULE$.containerAndPath(_container, PithosApi$.MODULE$.normalizeDirectoryPath(_path));
        if (tuple2 != null) {
            Tuple2 tuple22;
            String container = (String)tuple2._1();
            String path = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)container, (Object)path);
            String container2 = (String)tuple23._1();
            String path2 = (String)tuple23._2();
            String string = _contentType;
            boolean bl = string == null ? true : "".equals(string);
            String string2 = bl ? PithosApi$.MODULE$.guessContentTypeFromPath(path2) : _contentType;
            String contentType = string2;
            return $this.call(new PutObjectCommand(serviceInfo, container2, path2, Buf.ByteArray$.Owned$.MODULE$.apply(bytes), contentType));
        }
        throw new MatchError(tuple2);
    }

    public static Future putObject(PithosApiSkeleton $this, ServiceInfo serviceInfo, String _container, String _path, Buf payload, String _contentType) {
        Tuple2<String, String> tuple2 = PithosApi$.MODULE$.containerAndPath(_container, PithosApi$.MODULE$.normalizeDirectoryPath(_path));
        if (tuple2 != null) {
            Tuple2 tuple22;
            String container = (String)tuple2._1();
            String path = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)container, (Object)path);
            String container2 = (String)tuple23._1();
            String path2 = (String)tuple23._2();
            String string = _contentType;
            boolean bl = string == null ? true : "".equals(string);
            String string2 = bl ? PithosApi$.MODULE$.guessContentTypeFromPath(path2) : _contentType;
            String contentType = string2;
            return $this.call(new PutObjectCommand(serviceInfo, container2, path2, payload, contentType));
        }
        throw new MatchError(tuple2);
    }

    public static Future deleteFile(PithosApiSkeleton $this, ServiceInfo serviceInfo, String _container, String _path) {
        Tuple2<String, String> tuple2 = PithosApi$.MODULE$.containerAndPath(_container, PithosApi$.MODULE$.normalizeDirectoryPath(_path));
        if (tuple2 != null) {
            Tuple2 tuple22;
            String container = (String)tuple2._1();
            String path = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)container, (Object)path);
            String container2 = (String)tuple23._1();
            String path2 = (String)tuple23._2();
            return $this.call(new DeleteFileCommand(serviceInfo, container2, path2));
        }
        throw new MatchError(tuple2);
    }

    public static Future deleteDirectory(PithosApiSkeleton $this, ServiceInfo serviceInfo, String _container, String _path) {
        Tuple2<String, String> tuple2 = PithosApi$.MODULE$.containerAndPath(_container, PithosApi$.MODULE$.normalizeDirectoryPath(_path));
        if (tuple2 != null) {
            Tuple2 tuple22;
            String container = (String)tuple2._1();
            String path = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)container, (Object)path);
            String container2 = (String)tuple23._1();
            String path2 = (String)tuple23._2();
            return $this.call(new DeleteDirectoryCommand(serviceInfo, container2, path2, DeleteDirectoryCommand$.MODULE$.apply$default$4()));
        }
        throw new MatchError(tuple2);
    }

    public static Future copyObject(PithosApiSkeleton $this, ServiceInfo serviceInfo, String _fromContainer, String _fromPath, String _toContainer, String _toPath) {
        Tuple2<String, String> tuple2 = PithosApi$.MODULE$.containerAndPath(_fromContainer, PithosApi$.MODULE$.normalizeDirectoryPath(_fromPath));
        if (tuple2 != null) {
            Tuple2 tuple22;
            String fromContainer = (String)tuple2._1();
            String fromPath = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)fromContainer, (Object)fromPath);
            String fromContainer2 = (String)tuple23._1();
            String fromPath2 = (String)tuple23._2();
            Tuple2<String, String> tuple24 = PithosApi$.MODULE$.containerAndPath(_toContainer, PithosApi$.MODULE$.normalizeDirectoryPath(_toPath));
            if (tuple24 != null) {
                Tuple2 tuple25;
                String toContainer = (String)tuple24._1();
                String toPath = (String)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)toContainer, (Object)toPath);
                String toContainer2 = (String)tuple26._1();
                String toPath2 = (String)tuple26._2();
                return $this.call(new CopyObjectCommand(serviceInfo, fromContainer2, fromPath2, toContainer2, toPath2));
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError(tuple2);
    }

    public static Nothing$ moveObject(PithosApiSkeleton $this, ServiceInfo serviceInfo, String fromContainer, String fromObj, String toContainer, String toObj) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public static Future listObjectsInContainer(PithosApiSkeleton $this, ServiceInfo serviceInfo, String container) {
        return $this.listObjectsInPath(serviceInfo, container, "");
    }

    public static Future listObjectsInPath(PithosApiSkeleton $this, ServiceInfo serviceInfo, String _container, String _path) {
        Tuple2<String, String> tuple2 = PithosApi$.MODULE$.containerAndPath(_container, PithosApi$.MODULE$.normalizeDirectoryPath(_path));
        if (tuple2 != null) {
            Tuple2 tuple22;
            String container = (String)tuple2._1();
            String path = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)container, (Object)path);
            String container2 = (String)tuple23._1();
            String path2 = (String)tuple23._2();
            return $this.call(new ListObjectsInPathCommand(serviceInfo, container2, path2));
        }
        throw new MatchError(tuple2);
    }

    public static Future checkExistsObject(PithosApiSkeleton $this, ServiceInfo serviceInfo, String _container, String _path) {
        Tuple2<String, String> tuple2 = PithosApi$.MODULE$.containerAndPath(_container, PithosApi$.MODULE$.normalizeDirectoryPath(_path));
        if (tuple2 != null) {
            Tuple2 tuple22;
            String container = (String)tuple2._1();
            String path = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)container, (Object)path);
            String container2 = (String)tuple23._1();
            String path2 = (String)tuple23._2();
            return $this.call(new CheckExistsObjectCommand(serviceInfo, container2, path2, CheckExistsObjectCommand$.MODULE$.apply$default$4()));
        }
        throw new MatchError(tuple2);
    }

    public static void $init$(PithosApiSkeleton $this) {
        $this.gr$grnet$pithosj$core$PithosApiSkeleton$_setter_$log_$eq(Logger$.MODULE$.apply($this.getClass()));
    }
}

