/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import [Ljava.lang.String;;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.Script;
import groovy.ui.GroovyMain;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GroovyShell
extends GroovyObjectSupport {
    public static final String[] EMPTY_ARGS = new String[0];
    private HashMap classMap = new HashMap();
    private MainClassLoader loader;
    private Binding context;
    private int counter;
    private CompilerConfiguration config;

    private static ClassLoader getLoader(ClassLoader cl) {
        if (cl != null) {
            return cl;
        }
        cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            return cl;
        }
        cl = GroovyShell.class.getClassLoader();
        if (cl != null) {
            return cl;
        }
        return null;
    }

    public static void main(String[] args) {
        GroovyMain.main(args);
    }

    public GroovyShell() {
        this(null, new Binding());
    }

    public GroovyShell(Binding binding) {
        this(null, binding);
    }

    public GroovyShell(CompilerConfiguration config) {
        this(new Binding(), config);
    }

    public GroovyShell(Binding binding, CompilerConfiguration config) {
        this(null, binding, config);
    }

    public GroovyShell(ClassLoader parent, Binding binding) {
        this(parent, binding, null);
    }

    public GroovyShell(ClassLoader parent) {
        this(parent, new Binding(), null);
    }

    public GroovyShell(ClassLoader parent, Binding binding, CompilerConfiguration config) {
        this.config = config;
        this.loader = new MainClassLoader(parent);
        this.context = binding;
    }

    public void initialiseBinding() {
        Map map = this.context.getVariables();
        if (map.get("shell") == null) {
            map.put("shell", this);
        }
    }

    public void resetLoadedClasses() {
        this.classMap.clear();
    }

    public GroovyShell(GroovyShell shell) {
        this(shell.loader, shell.context);
    }

    public Binding getContext() {
        return this.context;
    }

    public Object getProperty(String property) {
        Object answer = this.getVariable(property);
        if (answer == null) {
            answer = super.getProperty(property);
        }
        return answer;
    }

    public void setProperty(String property, Object newValue) {
        this.setVariable(property, newValue);
        try {
            super.setProperty(property, newValue);
        }
        catch (GroovyRuntimeException groovyRuntimeException) {
            // empty catch block
        }
    }

    public void run(File scriptFile, List list) throws CompilationFailedException, IOException {
        String[] args = new String[list.size()];
        this.run(scriptFile, list.toArray(args));
    }

    public void run(String scriptText, String fileName, List list) throws CompilationFailedException {
        String[] args = new String[list.size()];
        list.toArray(args);
        this.run(scriptText, fileName, args);
    }

    public void run(final File scriptFile, String[] args) throws CompilationFailedException, IOException {
        Class scriptClass;
        String scriptName = scriptFile.getName();
        int p = scriptName.lastIndexOf(".");
        if (p++ >= 0 && scriptName.substring(p).equals("java")) {
            System.err.println("error: cannot compile file with .java extension: " + scriptName);
            throw new CompilationFailedException(0, null);
        }
        Thread thread = Thread.currentThread();
        class DoSetContext
        implements PrivilegedAction {
            ClassLoader classLoader;
            private final /* synthetic */ Thread val$thread;

            public DoSetContext(ClassLoader loader, Thread val$thread) {
                this.val$thread = val$thread;
                this.classLoader = loader;
            }

            public Object run() {
                this.val$thread.setContextClassLoader(this.classLoader);
                return null;
            }
        }
        AccessController.doPrivileged(new DoSetContext(this.loader, thread));
        final ShellLoader loader = new ShellLoader();
        try {
            scriptClass = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws CompilationFailedException, IOException {
                    return loader.parseClass(scriptFile);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof CompilationFailedException) {
                throw (CompilationFailedException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (RuntimeException)pae.getException();
        }
        this.runMainOrTestOrRunnable(scriptClass, args);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runMainOrTestOrRunnable(Class scriptClass, String[] args) {
        if (scriptClass == null) {
            return;
        }
        try {
            scriptClass.getMethod("main", String;.class);
        }
        catch (NoSuchMethodException e) {
            if (this.isUnitTestCase(scriptClass)) {
                this.runTest(scriptClass);
                return;
            }
            if (!Runnable.class.isAssignableFrom(scriptClass)) throw new GroovyRuntimeException("This script or class could not be run. \nIt should either: \n- have a main method, \n- be a class extending GroovyTestCase, \n- or implement the Runnable interface.");
            Constructor constructor = null;
            Runnable runnable = null;
            Object var6_6 = null;
            try {
                constructor = scriptClass.getConstructor(new String[0].getClass());
                try {
                    runnable = (Runnable)constructor.newInstance(new Object[]{args});
                }
                catch (Throwable t) {
                    Throwable throwable = t;
                }
            }
            catch (NoSuchMethodException e1) {
                try {
                    constructor = scriptClass.getConstructor(new Class[0]);
                    try {
                        runnable = (Runnable)constructor.newInstance(new Object[0]);
                    }
                    catch (Throwable t) {
                        Throwable throwable = t;
                    }
                }
                catch (NoSuchMethodException nsme) {
                    NoSuchMethodException noSuchMethodException = nsme;
                }
            }
            if (constructor == null || runnable == null) void var6_12;
            throw new GroovyRuntimeException("This script or class could not be run. ", (Throwable)var6_12);
            runnable.run();
            return;
        }
        InvokerHelper.invokeMethod(scriptClass, "main", new Object[]{args});
    }

    private void runTest(Class scriptClass) {
        try {
            InvokerHelper.invokeStaticMethod("junit.textui.TestRunner", "run", new Object[]{scriptClass});
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("Failed to run the unit test. JUnit is not on the Classpath.");
        }
    }

    private boolean isUnitTestCase(Class scriptClass) {
        ShellLoader loader = new ShellLoader();
        boolean isUnitTestCase = false;
        try {
            try {
                Class<?> testCaseClass = this.loader.loadClass("groovy.util.GroovyTestCase");
                if (testCaseClass.isAssignableFrom(scriptClass)) {
                    isUnitTestCase = true;
                }
            }
            catch (ClassNotFoundException e) {}
        }
        catch (Throwable e) {
            // empty catch block
        }
        return isUnitTestCase;
    }

    public void run(String scriptText, String fileName, String[] args) throws CompilationFailedException {
        this.run(new ByteArrayInputStream(scriptText.getBytes()), fileName, args);
    }

    public Object run(final InputStream in, final String fileName, String[] args) throws CompilationFailedException {
        GroovyCodeSource gcs = (GroovyCodeSource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new GroovyCodeSource(in, fileName, "/groovy/shell");
            }
        });
        Class scriptClass = this.parseClass(gcs);
        this.runMainOrTestOrRunnable(scriptClass, args);
        return null;
    }

    public Object getVariable(String name) {
        return this.context.getVariables().get(name);
    }

    public void setVariable(String name, Object value) {
        this.context.setVariable(name, value);
    }

    public Object evaluate(GroovyCodeSource codeSource) throws CompilationFailedException {
        Script script = this.parse(codeSource);
        return script.run();
    }

    public Object evaluate(String scriptText, String fileName) throws CompilationFailedException {
        return this.evaluate(new ByteArrayInputStream(scriptText.getBytes()), fileName);
    }

    public Object evaluate(String scriptText, String fileName, String codeBase) throws CompilationFailedException {
        return this.evaluate(new GroovyCodeSource(new ByteArrayInputStream(scriptText.getBytes()), fileName, codeBase));
    }

    public Object evaluate(File file) throws CompilationFailedException, IOException {
        return this.evaluate(new GroovyCodeSource(file));
    }

    public Object evaluate(String scriptText) throws CompilationFailedException {
        return this.evaluate(new ByteArrayInputStream(scriptText.getBytes()), this.generateScriptName());
    }

    public Object evaluate(InputStream in) throws CompilationFailedException {
        return this.evaluate(in, this.generateScriptName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(InputStream in, String fileName) throws CompilationFailedException {
        Object object;
        block2: {
            Script script = null;
            try {
                script = this.parse(in, fileName);
                object = script.run();
                Object var6_5 = null;
                if (script == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (script == null) break block3;
                    InvokerHelper.removeClass(script.getClass());
                }
                throw throwable;
            }
            InvokerHelper.removeClass(script.getClass());
        }
        return object;
    }

    public Script parse(final InputStream in, final String fileName) throws CompilationFailedException {
        GroovyCodeSource gcs = (GroovyCodeSource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new GroovyCodeSource(in, fileName, "/groovy/shell");
            }
        });
        return this.parse(gcs);
    }

    private Class parseClass(GroovyCodeSource codeSource) throws CompilationFailedException {
        ShellLoader loader = new ShellLoader();
        return loader.parseClass(codeSource, false);
    }

    public Script parse(GroovyCodeSource codeSource) throws CompilationFailedException {
        return InvokerHelper.createScript(this.parseClass(codeSource), this.context);
    }

    public Script parse(File file) throws CompilationFailedException, IOException {
        return this.parse(new GroovyCodeSource(file));
    }

    public Script parse(String scriptText) throws CompilationFailedException {
        return this.parse(new ByteArrayInputStream(scriptText.getBytes()), this.generateScriptName());
    }

    public Script parse(String scriptText, String fileName) throws CompilationFailedException {
        return this.parse(new ByteArrayInputStream(scriptText.getBytes()), fileName);
    }

    public Script parse(InputStream in) throws CompilationFailedException {
        return this.parse(in, this.generateScriptName());
    }

    protected synchronized String generateScriptName() {
        return "Script" + ++this.counter + ".groovy";
    }

    private class MainClassLoader
    extends ClassLoader {
        public MainClassLoader(ClassLoader parent) {
            super(GroovyShell.getLoader(parent));
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object cached = GroovyShell.this.classMap.get(name);
            if (cached != null) {
                return (Class)cached;
            }
            ClassLoader parent = this.getParent();
            if (parent != null) {
                return parent.loadClass(name);
            }
            return super.loadClass(name, resolve);
        }
    }

    private class ShellLoader
    extends GroovyClassLoader {
        public ShellLoader() {
            super(GroovyShell.this.loader, GroovyShell.this.config);
        }

        public Class defineClass(ClassNode classNode, String file, String newCodeBase) {
            Class c = super.defineClass(classNode, file, newCodeBase);
            GroovyShell.this.classMap.put(c.getName(), this);
            return c;
        }
    }
}

