/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import groovy.lang.Closure;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.classgen.AsmClassGenerator;

public class MethodPointerExpression
extends Expression {
    private Expression expression;
    private String methodName;

    public MethodPointerExpression(Expression expression, String methodName) {
        this.expression = expression;
        this.methodName = methodName;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitMethodPointerExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return new MethodPointerExpression(transformer.transform(this.expression), this.methodName);
    }

    protected void resolveType(AsmClassGenerator resolver) {
        this.expression.resolve(resolver);
        this.setTypeClass(this.expression.getTypeClass());
    }

    public String getText() {
        return this.expression.getText() + ".&" + this.methodName;
    }

    public String getType() {
        return "groovy.lang.Closure";
    }

    public boolean isDynamic() {
        return false;
    }

    public Class getTypeClass() {
        return Closure.class;
    }
}

