/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

public class CompilerClassLoader
extends ClassLoader {
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];
    private ClassLoader parent = Thread.currentThread().getContextClassLoader();
    private InnerLoader inner = new InnerLoader();
    private Map map = new HashMap();

    public CompilerClassLoader() {
        super(Thread.currentThread().getContextClassLoader());
    }

    public void addPath(String path) throws MalformedURLException {
        this.inner.addPath(path);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.inner.loadClass(name);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    private class InnerLoader
    extends URLClassLoader {
        public InnerLoader() {
            super(EMPTY_URL_ARRAY);
        }

        public void addPath(String path) throws MalformedURLException {
            this.addURL(new File(path).toURL());
        }

        protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = (Class<?>)CompilerClassLoader.this.map.get(name);
            if (c != null) {
                return c;
            }
            try {
                c = super.findClass(name);
                CompilerClassLoader.this.map.put(name, c);
                return c;
            }
            catch (ClassNotFoundException cnfe) {
                c = CompilerClassLoader.this.parent.loadClass(name);
                CompilerClassLoader.this.map.put(name, c);
                return c;
            }
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, false);
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, false);
        }
    }
}

