/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import [Ljava.lang.String;;
import groovy.ui.GroovyMain;
import groovy.ui.InteractiveShell;
import java.lang.reflect.Method;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.groovy.tools.FileSystemCompiler;
import org.codehaus.groovy.tools.Grok;

public class GroovyStarter {
    static void printUsage() {
        System.out.println("possible programs are 'groovyc','groovy','console','grok' and 'groovysh'");
        System.exit(1);
    }

    public static void main(String[] oldArgs, ClassWorld classWorld) {
        try {
            ClassRealm system = classWorld.newRealm("system");
            ClassRealm groovy = classWorld.getRealm("groovy");
            groovy.importFrom("system", "");
            if (oldArgs.length == 0) {
                GroovyStarter.printUsage();
                System.exit(1);
            }
            String program = oldArgs[0].toLowerCase();
            String[] args = new String[oldArgs.length - 1];
            for (int i = 0; i < args.length; ++i) {
                args[i] = oldArgs[i + 1];
            }
            if (program.equals("groovyc")) {
                FileSystemCompiler.main(args);
            } else if (program.equals("groovy")) {
                GroovyMain.main(args);
            } else if (program.equals("console")) {
                Class<?> c = Class.forName("groovy.ui.Console");
                Method m = c.getMethod("main", String;.class);
                m.invoke(null, new Object[]{args});
            } else if (program.equals("groovysh")) {
                InteractiveShell.main(args);
            } else if (program.equals("grok")) {
                Grok.main(args);
            } else {
                System.out.println("unknown program " + program);
                GroovyStarter.printUsage();
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

