/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyResourceLoader;
import groovy.lang.GroovyRuntimeException;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.ClassWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;

public class GroovyClassLoader
extends SecureClassLoader {
    private Map cache = new HashMap();
    private GroovyResourceLoader resourceLoader = new GroovyResourceLoader(){
        private HashMap filenameCache = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URL loadGroovySource(final String filename) throws MalformedURLException {
            File file = null;
            HashMap hashMap = this.filenameCache;
            synchronized (hashMap) {
                file = (File)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        File f = (File)filenameCache.get(filename);
                        if (f == null || !f.exists()) {
                            f = GroovyClassLoader.this.getSourceFile(filename);
                        }
                        return f;
                    }
                });
                this.filenameCache.put(filename, file);
            }
            return file == null ? null : file.toURL();
        }
    };
    private CompilerConfiguration config;
    private String[] searchPaths;
    private Set additionalPaths = new HashSet();

    public void removeFromCache(Class aClass) {
        this.cache.remove(aClass);
    }

    public GroovyClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public GroovyClassLoader(ClassLoader loader) {
        this(loader, null);
    }

    public GroovyClassLoader(GroovyClassLoader parent) {
        this(parent, parent.config);
    }

    public GroovyClassLoader(ClassLoader loader, CompilerConfiguration config) {
        super(loader);
        if (config == null) {
            config = CompilerConfiguration.DEFAULT;
        }
        this.config = config;
    }

    public void setResourceLoader(GroovyResourceLoader resourceLoader) {
        if (resourceLoader == null) {
            throw new IllegalArgumentException("Resource loader must not be null!");
        }
        this.resourceLoader = resourceLoader;
    }

    public GroovyResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public Class defineClass(ClassNode classNode, String file) {
        return this.defineClass(classNode, file, "/groovy/defineClass");
    }

    public Class defineClass(ClassNode classNode, String file, String newCodeBase) {
        CodeSource codeSource = null;
        try {
            codeSource = new CodeSource(new URL("file", "", newCodeBase), (Certificate[])null);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        CompilationUnit unit = new CompilationUnit(this.config, codeSource, this);
        try {
            ClassCollector collector = this.createCollector(unit, classNode.getModule().getContext());
            unit.addClassNode(classNode);
            unit.setClassgenCallback(collector);
            unit.compile(7);
            return collector.generatedClass;
        }
        catch (CompilationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    public Class parseClass(File file) throws CompilationFailedException, IOException {
        return this.parseClass(new GroovyCodeSource(file));
    }

    public Class parseClass(String text, String fileName) throws CompilationFailedException {
        return this.parseClass(new ByteArrayInputStream(text.getBytes()), fileName);
    }

    public Class parseClass(String text) throws CompilationFailedException {
        return this.parseClass(new ByteArrayInputStream(text.getBytes()), "script" + System.currentTimeMillis() + ".groovy");
    }

    public Class parseClass(InputStream in) throws CompilationFailedException {
        return this.parseClass(in, "script" + System.currentTimeMillis() + ".groovy");
    }

    public Class parseClass(final InputStream in, final String fileName) throws CompilationFailedException {
        GroovyCodeSource gcs = (GroovyCodeSource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new GroovyCodeSource(in, fileName, "/groovy/script");
            }
        });
        return this.parseClass(gcs);
    }

    public Class parseClass(GroovyCodeSource codeSource) throws CompilationFailedException {
        return this.parseClass(codeSource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class parseClass(GroovyCodeSource codeSource, boolean shouldCache) throws CompilationFailedException {
        Object unit;
        String name = codeSource.getName();
        Class answer = null;
        Map map = this.cache;
        synchronized (map) {
            answer = (Class)this.cache.get(name);
            if (answer != null) {
                return answer == PARSING.class ? null : answer;
            }
            this.cache.put(name, PARSING.class);
        }
        try {
            unit = new CompilationUnit(this.config, codeSource.getCodeSource(), this);
            SourceUnit su = null;
            su = codeSource.getFile() == null ? ((CompilationUnit)unit).addSource(name, codeSource.getInputStream()) : ((CompilationUnit)unit).addSource(codeSource.getFile());
            ClassCollector collector = this.createCollector((CompilationUnit)unit, su);
            ((CompilationUnit)unit).setClassgenCallback(collector);
            int goalPhase = 7;
            if (this.config != null && this.config.getTargetDirectory() != null) {
                goalPhase = 8;
            }
            ((CompilationUnit)unit).compile(goalPhase);
            answer = collector.generatedClass;
            if (shouldCache) {
                Iterator iter = collector.getLoadedClasses().iterator();
                while (iter.hasNext()) {
                    Class clazz = (Class)iter.next();
                    this.cache.put(clazz.getName(), clazz);
                }
            }
        }
        finally {
            unit = this.cache;
            synchronized (unit) {
                this.cache.remove(name);
                if (shouldCache) {
                    this.cache.put(name, answer);
                }
            }
            try {
                codeSource.getInputStream().close();
            }
            catch (IOException e) {
                throw new GroovyRuntimeException("unable to close stream", e);
            }
        }
        return answer;
    }

    protected String[] getClassPath() {
        if (null == this.searchPaths) {
            String classpath;
            if (null != this.config && null != this.config.getClasspath()) {
                StringBuffer sb = new StringBuffer();
                Iterator iter = this.config.getClasspath().iterator();
                while (iter.hasNext()) {
                    sb.append(iter.next().toString());
                    sb.append(File.pathSeparatorChar);
                }
                sb.deleteCharAt(sb.length() - 1);
                classpath = sb.toString();
            } else {
                classpath = System.getProperty("java.class.path", ".");
            }
            ArrayList pathList = new ArrayList(this.additionalPaths);
            this.expandClassPath(pathList, null, classpath, false);
            this.searchPaths = new String[pathList.size()];
            this.searchPaths = pathList.toArray(this.searchPaths);
        }
        return this.searchPaths;
    }

    protected void expandClassPath(List pathList, String base, String classpath, boolean isManifestClasspath) {
        if (classpath != null) {
            String[] paths = isManifestClasspath ? classpath.split("[\\ ,:;]") : classpath.split(File.pathSeparator);
            for (int i = 0; i < paths.length; ++i) {
                if (paths.length <= 0) continue;
                File path = null;
                path = "".equals(base) ? new File(paths[i]) : new File(base, paths[i]);
                if (!path.exists()) continue;
                if (!path.isDirectory()) {
                    try {
                        Attributes classPathAttributes;
                        String manifestClassPath;
                        JarFile jar = new JarFile(path);
                        pathList.add(paths[i]);
                        Manifest manifest = jar.getManifest();
                        if (manifest == null || (manifestClassPath = (classPathAttributes = manifest.getMainAttributes()).getValue("Class-Path")) == null) continue;
                        this.expandClassPath(pathList, paths[i], manifestClassPath, true);
                    }
                    catch (IOException e) {}
                    continue;
                }
                pathList.add(paths[i]);
            }
        }
    }

    protected Class defineClass(String name, byte[] bytecode, ProtectionDomain domain) {
        return this.defineClass(name, bytecode, 0, bytecode.length, domain);
    }

    protected ClassCollector createCollector(CompilationUnit unit, SourceUnit su) {
        InnerLoader loader = (InnerLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new InnerLoader();
            }
        });
        return new ClassCollector(loader, unit, su);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class defineClass(String name, byte[] b) {
        Class<?> c = super.defineClass(name, b, 0, b.length);
        Map map = this.cache;
        synchronized (map) {
            this.cache.put(name, c);
        }
        return c;
    }

    public Class loadClass(String name, boolean lookupScriptFiles, boolean preferClassOverScript) throws ClassNotFoundException {
        return this.loadClass(name, lookupScriptFiles, preferClassOverScript, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String name, boolean lookupScriptFiles, boolean preferClassOverScript, boolean resolve) throws ClassNotFoundException {
        ClassNotFoundException last;
        Class cls;
        block26: {
            String className;
            int i;
            cls = null;
            Map map = this.cache;
            synchronized (map) {
                boolean reloadable;
                cls = (Class)this.cache.get(name);
                if (cls == NOT_RESOLVED.class) {
                    throw new ClassNotFoundException(name);
                }
                if (cls != null && !(reloadable = GroovyObject.class.isAssignableFrom(cls))) {
                    return cls;
                }
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null && (i = (className = name.replace('/', '.')).lastIndexOf(46)) != -1) {
                sm.checkPackageAccess(className.substring(0, i));
            }
            last = null;
            try {
                cls = super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException cnfe) {
                last = cnfe;
            }
            if (cls != null) {
                boolean recompile = false;
                if (this.getTimeStamp(cls) < Long.MAX_VALUE) {
                    Class<?>[] inters = cls.getInterfaces();
                    for (int i2 = 0; i2 < inters.length; ++i2) {
                        if (!inters[i2].getName().equals((class$groovy$lang$GroovyObject == null ? GroovyClassLoader.class$("groovy.lang.GroovyObject") : class$groovy$lang$GroovyObject).getName())) continue;
                        recompile = true;
                        break;
                    }
                }
                preferClassOverScript |= cls.getClassLoader() == this;
                if (preferClassOverScript |= !recompile) {
                    return cls;
                }
            }
            if (lookupScriptFiles) {
                try {
                    URL source = this.resourceLoader.loadGroovySource(name);
                    if (source == null || (cls == null || !this.isSourceNewer(source, cls)) && cls != null) break block26;
                    Map map2 = this.cache;
                    synchronized (map2) {
                        this.cache.put(name, null);
                    }
                    cls = this.parseClass(source.openStream(), name);
                }
                catch (Exception e) {
                    cls = null;
                    last = new ClassNotFoundException("Failed to parse groovy file: " + name, e);
                }
            }
        }
        if (cls == null) {
            if (last == null) {
                throw new AssertionError(true);
            }
            Map map = this.cache;
            synchronized (map) {
                this.cache.put(name, NOT_RESOLVED.class);
            }
            throw last;
        }
        Map map = this.cache;
        synchronized (map) {
            this.cache.put(name, cls);
        }
        return cls;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, true, false, resolve);
    }

    private long getTimeStamp(Class cls) {
        Long o;
        try {
            Field field = cls.getField("__timeStamp");
            o = (Long)field.get(null);
        }
        catch (Exception e) {
            return Long.MAX_VALUE;
        }
        return o;
    }

    private File getSourceFile(String name) {
        File source = null;
        String filename = name.replace('.', '/') + ".groovy";
        String[] paths = this.getClassPath();
        for (int i = 0; i < paths.length; ++i) {
            File file;
            String pathName = paths[i];
            File path = new File(pathName);
            if (!path.exists() || !path.isDirectory() || !(file = new File(path, filename)).exists()) continue;
            boolean fileExists = false;
            int sepp = filename.lastIndexOf(47);
            String fn = filename;
            if (sepp >= 0) {
                fn = filename.substring(++sepp);
            }
            File parent = file.getParentFile();
            String[] files = parent.list();
            for (int j = 0; j < files.length; ++j) {
                if (!files[j].equals(fn)) continue;
                fileExists = true;
                break;
            }
            if (!fileExists) continue;
            source = file;
            break;
        }
        return source;
    }

    protected boolean isSourceNewer(URL source, Class cls) throws IOException {
        long lastMod;
        if (source.getProtocol().equals("file")) {
            String path = source.getPath().replace('/', File.separatorChar).replace('|', ':');
            File file = new File(path);
            lastMod = file.lastModified();
        } else {
            lastMod = source.openConnection().getLastModified();
        }
        return lastMod > this.getTimeStamp(cls);
    }

    public void addClasspath(String path) {
        this.additionalPaths.add(path);
        this.searchPaths = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class[] getLoadedClasses() {
        Class[] loadedClasses = null;
        HashSet<Class> set = new HashSet<Class>(this.cache.size());
        Map map = this.cache;
        synchronized (map) {
            Iterator iter = this.cache.values().iterator();
            while (iter.hasNext()) {
                Class element = (Class)iter.next();
                if (element == (class$groovy$lang$GroovyClassLoader$NOT_RESOLVED == null ? GroovyClassLoader.class$("groovy.lang.GroovyClassLoader$NOT_RESOLVED") : class$groovy$lang$GroovyClassLoader$NOT_RESOLVED)) continue;
                set.add(element);
            }
            loadedClasses = set.toArray(new Class[0]);
        }
        return loadedClasses;
    }

    public static class ClassCollector
    extends CompilationUnit.ClassgenCallback {
        private Class generatedClass;
        private GroovyClassLoader cl;
        private SourceUnit su;
        private CompilationUnit unit;
        private Collection loadedClasses = null;

        protected ClassCollector(GroovyClassLoader cl, CompilationUnit unit, SourceUnit su) {
            this.cl = cl;
            this.unit = unit;
            this.loadedClasses = new ArrayList();
            this.su = su;
        }

        protected Class onClassNode(ClassWriter classWriter, ClassNode classNode) {
            byte[] code = classWriter.toByteArray();
            Class theClass = this.cl.defineClass(classNode.getName(), code, 0, code.length, this.unit.getAST().getCodeSource());
            this.loadedClasses.add(theClass);
            if (this.generatedClass == null) {
                ModuleNode mn = classNode.getModule();
                SourceUnit msu = null;
                if (mn != null) {
                    msu = mn.getContext();
                }
                ClassNode main = null;
                if (mn != null) {
                    main = (ClassNode)mn.getClasses().get(0);
                }
                if (msu == this.su && main == classNode) {
                    this.generatedClass = theClass;
                }
            }
            return theClass;
        }

        public void call(ClassVisitor classWriter, ClassNode classNode) {
            this.onClassNode((ClassWriter)classWriter, classNode);
        }

        public Collection getLoadedClasses() {
            return this.loadedClasses;
        }
    }

    private class InnerLoader
    extends GroovyClassLoader {
        InnerLoader() {
            super(GroovyClassLoader.this);
        }

        public Class loadClass(String name, boolean lookupScriptFiles, boolean preferClassOverScript, boolean resolve) throws ClassNotFoundException {
            return GroovyClassLoader.this.loadClass(name, lookupScriptFiles, preferClassOverScript, resolve);
        }

        public Class parseClass(GroovyCodeSource codeSource, boolean shouldCache) throws CompilationFailedException {
            return GroovyClassLoader.this.parseClass(codeSource, shouldCache);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Class defineClass(String name, byte[] b) {
            Class<?> c = super.defineClass(name, b, 0, b.length);
            Map map = GroovyClassLoader.this.cache;
            synchronized (map) {
                GroovyClassLoader.this.cache.put(name, c);
            }
            return c;
        }

        protected ClassCollector createCollector(CompilationUnit unit, SourceUnit su) {
            return GroovyClassLoader.this.createCollector(unit, su);
        }

        public void addClasspath(String path) {
            GroovyClassLoader.this.addClasspath(path);
        }

        public Class[] getLoadedClasses() {
            return GroovyClassLoader.this.getLoadedClasses();
        }
    }

    private class NOT_RESOLVED {
        private NOT_RESOLVED() {
        }
    }

    public static class PARSING {
    }
}

