/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.Reflector;

public class MetaMethod
implements Cloneable {
    private static final Logger log = Logger.getLogger(MetaMethod.class.getName());
    private String name;
    private Class declaringClass;
    private Class interfaceClass;
    private Class[] parameterTypes;
    private Class returnType;
    private int modifiers;
    private Reflector reflector;
    private int methodIndex;
    private Method method;

    public MetaMethod(String name, Class declaringClass, Class[] parameterTypes, Class returnType, int modifiers) {
        this.name = name;
        this.declaringClass = declaringClass;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.modifiers = modifiers;
    }

    public MetaMethod(Method method) {
        this(method.getName(), method.getDeclaringClass(), method.getParameterTypes(), method.getReturnType(), method.getModifiers());
        this.method = method;
    }

    public MetaMethod(MetaMethod metaMethod) {
        this(metaMethod.method);
    }

    public void checkParameters(Class[] arguments) {
        if (!MetaClass.isValidMethod(this.getParameterTypes(), arguments, false)) {
            throw new IllegalArgumentException("Parameters to method: " + this.getName() + " do not match types: " + InvokerHelper.toString(this.getParameterTypes()) + " for arguments: " + InvokerHelper.toString(arguments));
        }
    }

    public Object invoke(Object object, Object[] arguments) throws Exception {
        if (this.reflector != null) {
            return this.reflector.invoke(this, object, arguments);
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                MetaMethod.this.method.setAccessible(true);
                return null;
            }
        });
        return this.method.invoke(object, arguments);
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public void setDeclaringClass(Class c) {
        this.declaringClass = c;
    }

    public int getMethodIndex() {
        return this.methodIndex;
    }

    public void setMethodIndex(int methodIndex) {
        this.methodIndex = methodIndex;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public Reflector getReflector() {
        return this.reflector;
    }

    public void setReflector(Reflector reflector) {
        this.reflector = reflector;
    }

    public boolean isMethod(Method method) {
        return this.name.equals(method.getName()) && this.modifiers == method.getModifiers() && this.returnType.equals(method.getReturnType()) && this.equal(this.parameterTypes, method.getParameterTypes());
    }

    protected boolean equal(Class[] a, Class[] b) {
        if (a.length == b.length) {
            int size = a.length;
            for (int i = 0; i < size; ++i) {
                if (a[i].equals(b[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return super.toString() + "[name: " + this.name + " params: " + InvokerHelper.toString(this.parameterTypes) + " returns: " + this.returnType + " owner: " + this.declaringClass + "]";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new GroovyRuntimeException("This should never happen", e);
        }
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isSame(MetaMethod method) {
        return this.name.equals(method.getName()) && this.compatibleModifiers(this.modifiers, method.getModifiers()) && this.returnType.equals(method.getReturnType()) && this.equal(this.parameterTypes, method.getParameterTypes());
    }

    protected boolean compatibleModifiers(int modifiersA, int modifiersB) {
        int mask = 15;
        return (modifiersA & mask) == (modifiersB & mask);
    }

    public Class getInterfaceClass() {
        return this.interfaceClass;
    }

    public void setInterfaceClass(Class interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public boolean isCacheable() {
        return true;
    }
}

