/*
 * Decompiled with CFR 0.152.
 */
package groovy.net.xmlrpc;

import groovy.lang.Closure;
import groovy.lang.GroovyRuntimeException;
import groovy.net.xmlrpc.RPCServer;
import groovy.net.xmlrpc.XMLRPCMessageProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import uk.co.wilson.net.MinMLThreadPool;
import uk.co.wilson.net.http.MinMLHTTPServer;
import uk.co.wilson.net.xmlrpc.XMLRPCFailException;

public class XMLRPCServer
extends RPCServer {
    private byte[] base64 = new byte[600];
    static byte[] host;
    static final String xmlDeclaration = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
    static final byte[] userAgent;
    static final byte[] contentTypeXML;
    static final byte[] contentLength;
    final int minWorkers;
    final int maxWorkers;
    final int maxKeepAlives;
    final int workerIdleLife;
    final int socketReadTimeout;

    public byte[] getBase64() {
        return this.base64;
    }

    public XMLRPCServer(int minWorkers, int maxWorkers, int maxKeepAlives, int workerIdleLife, int socketReadTimeout) {
        for (int i = 0; i != this.base64.length; ++i) {
            this.base64[i] = (byte)i;
        }
        this.minWorkers = minWorkers;
        this.maxWorkers = maxWorkers;
        this.maxKeepAlives = maxKeepAlives;
        this.workerIdleLife = workerIdleLife;
        this.socketReadTimeout = socketReadTimeout;
    }

    public XMLRPCServer() {
        this(2, 10, 8, 60000, 60000);
    }

    public void startServer(ServerSocket serverSocket) throws IOException {
        if (this.server != null) {
            this.stopServer();
        }
        final MinMLHTTPServer server = new MinMLHTTPServer(serverSocket, this.minWorkers, this.maxWorkers, this.maxKeepAlives, this.workerIdleLife, this.socketReadTimeout){

            protected MinMLThreadPool.Worker makeNewWorker() {
                return new MinMLHTTPServer.HTTPWorker(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super(this$1);
                    }

                    protected void processPost(InputStream in, OutputStream out, String uri, String version) throws Exception {
                        try {
                            XMLRPCMessageProcessor requestParser = new XMLRPCMessageProcessor();
                            out.write(version.getBytes());
                            out.write(1.access$000());
                            out.write(userAgent);
                            out.write(host);
                            out.write(contentTypeXML);
                            this.writeKeepAlive(out);
                            out.write(contentLength);
                            requestParser.parseMessage(in);
                            String methodName = requestParser.getMethodname();
                            List params = requestParser.getParams();
                            Closure closure = (Closure)1.access$100(this.this$1).registeredMethods.get(methodName);
                            Object result = null;
                            if (1.access$100(this.this$1).preCallMethod != null) {
                                1.access$100(this.this$1).preCallMethod.call(new Object[]{methodName, params.toArray()});
                            }
                            if (closure == null) {
                                if (1.access$100(this.this$1).defaultMethod == null) {
                                    throw new GroovyRuntimeException("Method " + methodName + " is not supported on this server");
                                }
                                result = 1.access$100(this.this$1).defaultMethod.call(new Object[]{methodName, params.toArray()});
                            } else {
                                result = closure.call(params.toArray());
                            }
                            if (result == null) {
                                result = new Integer(0);
                            }
                            if (1.access$100(this.this$1).postCallMethod != null) {
                                1.access$100(this.this$1).postCallMethod.call(new Object[]{methodName, result});
                            }
                            byte[] response = XMLRPCMessageProcessor.emitResult(new StringBuffer("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n"), result).toString().getBytes("ISO-8859-1");
                            out.write(String.valueOf(response.length).getBytes());
                            out.write(1.access$200());
                            out.write(1.access$300());
                            out.write(response);
                        }
                        catch (Throwable e) {
                            int codeValue;
                            String message;
                            if (e instanceof InvokerInvocationException) {
                                e = ((InvokerInvocationException)e).getCause();
                            }
                            if (e instanceof XMLRPCFailException) {
                                message = ((XMLRPCFailException)e).getFaultString();
                                codeValue = ((XMLRPCFailException)e).getFaultCode();
                            } else {
                                message = e.getMessage();
                                codeValue = 0;
                            }
                            if (1.access$100(this.this$1).faultMethod != null) {
                                try {
                                    1.access$100(this.this$1).faultMethod.call(new Object[]{message, new Integer(codeValue)});
                                }
                                catch (Throwable e1) {
                                    // empty catch block
                                }
                            }
                            byte[] error = XMLRPCMessageProcessor.emitError(new StringBuffer("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n"), codeValue, message == null ? e.getClass().getName() : message).toString().getBytes("ISO-8859-1");
                            out.write(String.valueOf(error.length).getBytes());
                            out.write(1.access$400());
                            out.write(1.access$500());
                            out.write(error);
                        }
                    }
                };
            }

            static /* synthetic */ byte[] access$000() {
                return okMessage;
            }

            static /* synthetic */ XMLRPCServer access$100(1 x0) {
                return x0.XMLRPCServer.this;
            }

            static /* synthetic */ byte[] access$200() {
                return endOfLine;
            }

            static /* synthetic */ byte[] access$300() {
                return endOfLine;
            }

            static /* synthetic */ byte[] access$400() {
                return endOfLine;
            }

            static /* synthetic */ byte[] access$500() {
                return endOfLine;
            }
        };
        this.server = server;
        Thread startingThread = new Thread(){

            public void run() {
                server.start();
            }
        };
        startingThread.setDaemon(false);
        startingThread.setName("XML-RPC Server main thread");
        startingThread.start();
    }

    static {
        try {
            host = ("Host: " + InetAddress.getLocalHost().getHostName() + "\r\n").getBytes();
        }
        catch (UnknownHostException e) {
            host = "Host: unknown\r\n ".getBytes();
        }
        userAgent = "User-Agent: Groovy XML-RPC\r\n".getBytes();
        contentTypeXML = "Content-Type: text/xml\r\n".getBytes();
        contentLength = "Content-Length: ".getBytes();
    }
}

