/*
 * Decompiled with CFR 0.152.
 */
package uk.co.wilson.net.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;
import uk.co.wilson.net.MinMLSocketServer;

public abstract class MinMLHTTPServer
extends MinMLSocketServer {
    private int keepAliveCount = 0;
    protected final int maxKeepAlives;
    protected final int socketReadTimeout;
    protected static final byte[] okMessage = " 200 OK \r\nServer: uk.co.wilson.net.http.HTTPServer\r\n".getBytes();
    protected static final byte[] endOfLine = "\r\n".getBytes();
    protected static final byte[] get = "GET".getBytes();
    protected static final byte[] head = "HEAD".getBytes();
    protected static final byte[] post = "POST".getBytes();
    protected static final byte[] put = "PUT".getBytes();
    protected static final byte[] errorMessage1 = " 400 Bad Request\r\nServer: uk.co.wilson.net.http.HTTPServer\r\n\r\nMethod ".getBytes();
    protected static final byte[] errorMessage2 = " not implemented\r\n".getBytes();
    protected static final byte[] keepConnection = "Connection: Keep-Alive\r\n".getBytes();
    protected static final byte[] closeConnection = "Connection: Close\r\n".getBytes();

    public MinMLHTTPServer(ServerSocket serverSocket, int minWorkers, int maxWorkers, int maxKeepAlives, int workerIdleLife, int socketReadTimeout) {
        super(serverSocket, minWorkers, maxWorkers, workerIdleLife);
        this.maxKeepAlives = maxKeepAlives;
        this.socketReadTimeout = socketReadTimeout;
    }

    private synchronized boolean startKeepAlive() {
        if (this.keepAliveCount < this.maxKeepAlives) {
            ++this.keepAliveCount;
            return true;
        }
        return false;
    }

    private synchronized void endKeepAlive() {
        --this.keepAliveCount;
    }

    protected abstract class HTTPWorker
    extends MinMLSocketServer.ServerSocketWorker {
        private final byte[] buf;
        private int count;
        private boolean keepAlive;

        protected HTTPWorker() {
            super(MinMLHTTPServer.this);
            this.buf = new byte[256];
            this.count = 0;
            this.keepAlive = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final void process(Object resource) throws Exception {
            Socket socket = (Socket)resource;
            try {
                socket.setSoTimeout(MinMLHTTPServer.this.socketReadTimeout);
                BufferedInputStream in = new BufferedInputStream(socket.getInputStream());
                BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
                do {
                    String version;
                    int contentLength = -1;
                    while (this.readLine(in) != -1 && this.count == 0) {
                    }
                    StringTokenizer toks = new StringTokenizer(new String(this.buf, 0, this.count));
                    String method = toks.nextToken();
                    String uri = toks.nextToken();
                    String string = version = toks.hasMoreTokens() ? toks.nextToken() : "";
                    while (this.readLine(in) != -1 && this.count != 0) {
                        String option = new String(this.buf, 0, this.count).trim().toLowerCase();
                        if (option.startsWith("connection:")) {
                            if (option.endsWith("keep-alive")) {
                                if (this.keepAlive) continue;
                                this.keepAlive = MinMLHTTPServer.this.startKeepAlive();
                                continue;
                            }
                            if (!this.keepAlive) continue;
                            MinMLHTTPServer.this.endKeepAlive();
                            this.keepAlive = false;
                            continue;
                        }
                        if (!option.startsWith("content-length:")) continue;
                        contentLength = Integer.parseInt(option.substring(15).trim());
                    }
                    if (contentLength == -1) {
                        this.processMethod(in, out, method, uri, version);
                    } else {
                        LimitedInputStream limitedIn = new LimitedInputStream(in, contentLength);
                        this.processMethod(limitedIn, out, method, uri, version);
                        ((InputStream)limitedIn).close();
                    }
                    ((OutputStream)out).flush();
                    if (contentLength == -1) break;
                } while (this.keepAlive);
                Object var12_11 = null;
                if (!this.keepAlive) return;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (!this.keepAlive) throw throwable;
                MinMLHTTPServer.this.endKeepAlive();
                this.keepAlive = false;
                throw throwable;
            }
            MinMLHTTPServer.this.endKeepAlive();
            this.keepAlive = false;
        }

        protected void processMethod(InputStream in, OutputStream out, String method, String uri, String version) throws Exception {
            if (method.equalsIgnoreCase("GET")) {
                this.processGet(in, out, uri, version);
            } else if (method.equalsIgnoreCase("HEAD")) {
                this.processHead(in, out, uri, version);
            } else if (method.equalsIgnoreCase("POST")) {
                this.processPost(in, out, uri, version);
            } else if (method.equalsIgnoreCase("PUT")) {
                this.processPut(in, out, uri, version);
            } else {
                this.processOther(in, out, method, uri, version);
            }
        }

        protected void processGet(InputStream in, OutputStream out, String uri, String version) throws Exception {
            out.write(version.getBytes());
            out.write(errorMessage1);
            out.write(get);
            out.write(errorMessage2);
        }

        protected void processHead(InputStream in, OutputStream out, String uri, String version) throws Exception {
            out.write(version.getBytes());
            out.write(errorMessage1);
            out.write(head);
            out.write(errorMessage2);
        }

        protected void processPost(InputStream in, OutputStream out, String uri, String version) throws Exception {
            out.write(version.getBytes());
            out.write(errorMessage1);
            out.write(post);
            out.write(errorMessage2);
        }

        protected void processPut(InputStream in, OutputStream out, String uri, String version) throws Exception {
            out.write(version.getBytes());
            out.write(errorMessage1);
            out.write(put);
            out.write(errorMessage2);
        }

        protected void processOther(InputStream in, OutputStream out, String method, String uri, String version) throws Exception {
            out.write(version.getBytes());
            out.write(errorMessage1);
            out.write(method.getBytes());
            out.write(errorMessage2);
        }

        protected void writeKeepAlive(OutputStream res) throws IOException {
            res.write(this.keepAlive ? keepConnection : closeConnection);
        }

        private int readLine(InputStream in) throws IOException {
            int nextByte;
            this.count = 0;
            while (((nextByte = in.read()) != 13 || (nextByte = in.read()) != 10) && nextByte != -1) {
                this.buf[this.count] = (byte)nextByte;
                if (this.count == this.buf.length - 1) continue;
                ++this.count;
            }
            return nextByte;
        }
    }

    private static class LimitedInputStream
    extends InputStream {
        private int contentLength;
        private final InputStream in;

        public LimitedInputStream(InputStream in, int contentLength) {
            this.in = in;
            this.contentLength = contentLength;
        }

        public int available() throws IOException {
            return Math.min(this.in.available(), this.contentLength);
        }

        public void close() throws IOException {
            this.skip(this.contentLength);
        }

        public int read() throws IOException {
            if (this.contentLength == 0) {
                return -1;
            }
            --this.contentLength;
            return this.in.read();
        }

        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            if (this.contentLength == 0) {
                return -1;
            }
            if ((length = this.in.read(buffer, offset, Math.min(length, this.contentLength))) != -1) {
                this.contentLength -= length;
            }
            return length;
        }

        public long skip(long count) throws IOException {
            count = Math.min(count, (long)this.contentLength);
            this.contentLength = (int)((long)this.contentLength - count);
            return this.in.skip(count);
        }
    }
}

