/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import [Ljava.lang.Object;;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaArrayLengthProperty;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaFieldProperty;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import groovy.lang.MissingFieldException;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.ReadOnlyPropertyException;
import groovy.lang.TypeMismatchException;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.ClassWriter;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.ReflectorGenerator;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.CurriedClosure;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GroovyCategorySupport;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.runtime.NewInstanceMetaMethod;
import org.codehaus.groovy.runtime.NewStaticMetaMethod;
import org.codehaus.groovy.runtime.ReflectionMetaMethod;
import org.codehaus.groovy.runtime.Reflector;
import org.codehaus.groovy.runtime.TemporaryMethodKey;
import org.codehaus.groovy.runtime.TransformMetaMethod;

public class MetaClassImpl
extends MetaClass {
    protected MetaClassRegistry registry;
    private ClassNode classNode;
    private Map methodIndex = new HashMap();
    private Map staticMethodIndex = new HashMap();
    private Map propertyMap = Collections.synchronizedMap(new HashMap());
    private Map listeners = new HashMap();
    private Map methodCache = Collections.synchronizedMap(new HashMap());
    private Map staticMethodCache = Collections.synchronizedMap(new HashMap());
    private MetaMethod genericGetMethod;
    private MetaMethod genericSetMethod;
    private List constructors;
    private List allMethods = new ArrayList();
    private List interfaceMethods;
    private Reflector reflector;
    private boolean initialised;
    private MetaProperty arrayLengthProperty = new MetaArrayLengthProperty();

    public MetaClassImpl(MetaClassRegistry registry, final Class theClass) throws IntrospectionException {
        super(theClass);
        this.registry = registry;
        this.constructors = (List)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Arrays.asList(theClass.getDeclaredConstructors());
            }
        });
        this.addMethods(theClass, true);
        BeanInfo info = null;
        try {
            info = (BeanInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IntrospectionException {
                    return Introspector.getBeanInfo(theClass);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            if (pae.getException() instanceof IntrospectionException) {
                throw (IntrospectionException)pae.getException();
            }
            throw new RuntimeException(pae.getException());
        }
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        this.setupProperties(descriptors);
        EventSetDescriptor[] eventDescriptors = info.getEventSetDescriptors();
        for (int i = 0; i < eventDescriptors.length; ++i) {
            EventSetDescriptor descriptor = eventDescriptors[i];
            Method[] listenerMethods = descriptor.getListenerMethods();
            for (int j = 0; j < listenerMethods.length; ++j) {
                Method listenerMethod = listenerMethods[j];
                MetaMethod metaMethod = this.createMetaMethod(descriptor.getAddListenerMethod());
                this.listeners.put(listenerMethod.getName(), metaMethod);
            }
        }
    }

    private void addInheritedMethods() {
        LinkedList superClasses = new LinkedList();
        for (Class c = this.theClass.getSuperclass(); c != (class$java$lang$Object == null ? MetaClassImpl.class$("java.lang.Object") : class$java$lang$Object) && c != null; c = c.getSuperclass()) {
            superClasses.addFirst(c);
        }
        Iterator iter = superClasses.iterator();
        while (iter.hasNext()) {
            Class c = (Class)iter.next();
            this.addMethods(c, true);
            this.addNewStaticMethodsFrom(c);
        }
        Class<?>[] interfaces = this.theClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.addNewStaticMethodsFrom(interfaces[i]);
        }
        if (this.theClass != Object.class) {
            this.addMethods(Object.class, false);
            this.addNewStaticMethodsFrom(Object.class);
        }
        if (this.theClass.isArray() && !this.theClass.equals(Object;.class)) {
            this.addNewStaticMethodsFrom(Object;.class);
        }
    }

    private List getMethods(String name) {
        List answer = (List)this.methodIndex.get(name);
        List used = GroovyCategorySupport.getCategoryMethods(this.theClass, name);
        if (used != null) {
            if (answer != null) {
                used.addAll(answer);
            }
            answer = used;
        }
        if (answer == null) {
            answer = Collections.EMPTY_LIST;
        }
        return answer;
    }

    private List getStaticMethods(String name) {
        List answer = (List)this.staticMethodIndex.get(name);
        if (answer == null) {
            return Collections.EMPTY_LIST;
        }
        return answer;
    }

    protected void addNewInstanceMethod(Method method) {
        if (this.initialised) {
            throw new RuntimeException("Already initialized, cannot add new method: " + method);
        }
        NewInstanceMetaMethod newMethod = new NewInstanceMetaMethod(this.createMetaMethod(method));
        if (!this.newGroovyMethodsList.contains(newMethod)) {
            this.newGroovyMethodsList.add(newMethod);
            this.addMethod(newMethod, false);
        }
    }

    protected void addNewStaticMethod(Method method) {
        if (this.initialised) {
            throw new RuntimeException("Already initialized, cannot add new method: " + method);
        }
        NewStaticMetaMethod newMethod = new NewStaticMetaMethod(this.createMetaMethod(method));
        if (!this.newGroovyMethodsList.contains(newMethod)) {
            this.newGroovyMethodsList.add(newMethod);
            this.addMethod(newMethod, false);
        }
    }

    public Object invokeMethod(Object object, String methodName, Object[] arguments) {
        if (object == null) {
            throw new NullPointerException("Cannot invoke method: " + methodName + " on null object");
        }
        if (log.isLoggable(Level.FINER)) {
            MetaClassHelper.logMethodCall(object, methodName, arguments);
        }
        MetaMethod method = this.retrieveMethod(object, methodName, arguments);
        boolean isClosure = object instanceof Closure;
        if (isClosure) {
            MetaClass delegateMetaClass;
            MetaClass ownerMetaClass;
            Closure closure = (Closure)object;
            Object delegate = closure.getDelegate();
            Object owner = closure.getOwner();
            if ("call".equals(methodName) || "doCall".equals(methodName)) {
                if (object.getClass() == MethodClosure.class) {
                    MethodClosure mc = (MethodClosure)object;
                    methodName = mc.getMethod();
                    MetaClass ownerMetaClass2 = this.registry.getMetaClass(owner.getClass());
                    return ownerMetaClass2.invokeMethod(owner, methodName, arguments);
                }
                if (object.getClass() == CurriedClosure.class) {
                    CurriedClosure cc = (CurriedClosure)object;
                    arguments = cc.getUncurriedArguments(arguments);
                    MetaClass ownerMetaClass3 = this.registry.getMetaClass(owner.getClass());
                    return ownerMetaClass3.invokeMethod(owner, methodName, arguments);
                }
            } else if ("curry".equals(methodName)) {
                return closure.curry(arguments);
            }
            if (method == null && owner != closure && (method = (ownerMetaClass = this.registry.getMetaClass(owner.getClass())).retrieveMethod(owner, methodName, arguments)) != null) {
                return ownerMetaClass.invokeMethod(owner, methodName, arguments);
            }
            if (method == null && delegate != closure && delegate != null && (method = (delegateMetaClass = this.registry.getMetaClass(delegate.getClass())).retrieveMethod(delegate, methodName, arguments)) != null) {
                return delegateMetaClass.invokeMethod(delegate, methodName, arguments);
            }
            if (method == null) {
                MissingMethodException last;
                block22: {
                    last = null;
                    if (owner != closure && owner instanceof GroovyObject) {
                        try {
                            GroovyObject go = (GroovyObject)owner;
                            return go.invokeMethod(methodName, arguments);
                        }
                        catch (MissingMethodException mme) {
                            if (last != null) break block22;
                            last = mme;
                        }
                    }
                }
                if (delegate != closure && delegate instanceof GroovyObject) {
                    try {
                        GroovyObject go = (GroovyObject)delegate;
                        return go.invokeMethod(methodName, arguments);
                    }
                    catch (MissingMethodException mme) {
                        last = mme;
                    }
                }
                if (last != null) {
                    throw last;
                }
            }
        }
        if (method != null) {
            return MetaClassHelper.doMethodInvoke(object, method, arguments);
        }
        try {
            Object value = this.getProperty(object, methodName);
            if (value instanceof Closure) {
                Closure closure = (Closure)value;
                MetaClass delegateMetaClass = this.registry.getMetaClass(closure.getClass());
                return delegateMetaClass.invokeMethod((Object)closure, "doCall", arguments);
            }
        }
        catch (MissingPropertyException mpe) {
            // empty catch block
        }
        throw new MissingMethodException(methodName, this.theClass, arguments);
    }

    public MetaMethod retrieveMethod(Object owner, String methodName, Object[] arguments) {
        TemporaryMethodKey methodKey = new TemporaryMethodKey(methodName, arguments);
        MetaMethod method = (MetaMethod)this.methodCache.get(methodKey);
        if (method == null && (method = this.pickMethod(owner, methodName, arguments)) != null && method.isCacheable()) {
            this.methodCache.put(methodKey.createCopy(), method);
        }
        return method;
    }

    public MetaMethod retrieveMethod(String methodName, Class[] arguments) {
        TemporaryMethodKey methodKey = new TemporaryMethodKey(methodName, arguments);
        MetaMethod method = (MetaMethod)this.methodCache.get(methodKey);
        if (method == null && (method = this.pickMethod(methodName, arguments)) != null && method.isCacheable()) {
            this.methodCache.put(methodKey.createCopy(), method);
        }
        return method;
    }

    public Constructor retrieveConstructor(Class[] arguments) {
        Constructor constructor = (Constructor)this.chooseMethod("<init>", this.constructors, arguments, false);
        if (constructor != null) {
            return constructor;
        }
        constructor = (Constructor)this.chooseMethod("<init>", this.constructors, arguments, true);
        if (constructor != null) {
            return constructor;
        }
        return null;
    }

    public MetaMethod retrieveStaticMethod(String methodName, Class[] arguments) {
        TemporaryMethodKey methodKey = new TemporaryMethodKey(methodName, arguments);
        MetaMethod method = (MetaMethod)this.staticMethodCache.get(methodKey);
        if (method == null && (method = this.pickStaticMethod(methodName, arguments)) != null) {
            this.staticMethodCache.put(methodKey.createCopy(), method);
        }
        return method;
    }

    protected MetaMethod pickMethod(Object object, String methodName, Object[] arguments) {
        Class[] argClasses;
        MetaMethod method = null;
        List methods = this.getMethods(methodName);
        if (!methods.isEmpty() && (method = (MetaMethod)this.chooseMethod(methodName, methods, argClasses = MetaClassHelper.convertToTypeArray(arguments), true)) == null) {
            Object firstArgument;
            int size;
            int n = size = arguments != null ? arguments.length : 0;
            if (size == 1 && (firstArgument = arguments[0]) instanceof List) {
                List list = (List)firstArgument;
                arguments = list.toArray();
                argClasses = MetaClassHelper.convertToTypeArray(arguments);
                method = (MetaMethod)this.chooseMethod(methodName, methods, argClasses, true);
                if (method == null) {
                    return null;
                }
                return new TransformMetaMethod(method){

                    public Object invoke(Object object, Object[] arguments) throws Exception {
                        Object firstArgument = arguments[0];
                        List list = (List)firstArgument;
                        arguments = list.toArray();
                        return super.invoke(object, arguments);
                    }
                };
            }
        }
        return method;
    }

    protected MetaMethod pickMethod(String methodName, Class[] arguments) {
        MetaMethod method = null;
        List methods = this.getMethods(methodName);
        if (!methods.isEmpty()) {
            method = (MetaMethod)this.chooseMethod(methodName, methods, arguments, false);
        }
        return method;
    }

    public Object invokeStaticMethod(Object object, String methodName, Object[] arguments) {
        TemporaryMethodKey methodKey;
        MetaMethod method;
        if (log.isLoggable(Level.FINER)) {
            MetaClassHelper.logMethodCall(object, methodName, arguments);
        }
        if ((method = (MetaMethod)this.staticMethodCache.get(methodKey = new TemporaryMethodKey(methodName, arguments))) == null && (method = this.pickStaticMethod(object, methodName, arguments)) != null) {
            this.staticMethodCache.put(methodKey.createCopy(), method);
        }
        if (method != null) {
            return MetaClassHelper.doMethodInvoke(object, method, arguments);
        }
        throw new MissingMethodException(methodName, this.theClass, arguments);
    }

    private MetaMethod pickStaticMethod(Object object, String methodName, Object[] arguments) {
        MetaMethod method = null;
        List methods = this.getStaticMethods(methodName);
        if (!methods.isEmpty()) {
            method = (MetaMethod)this.chooseMethod(methodName, methods, MetaClassHelper.convertToTypeArray(arguments), false);
        }
        if (method == null && this.theClass != Class.class) {
            MetaClass classMetaClass = this.registry.getMetaClass(Class.class);
            method = classMetaClass.pickMethod(object, methodName, arguments);
        }
        if (method == null) {
            method = (MetaMethod)this.chooseMethod(methodName, methods, MetaClassHelper.convertToTypeArray(arguments), true);
        }
        return method;
    }

    private MetaMethod pickStaticMethod(String methodName, Class[] arguments) {
        MetaMethod method = null;
        List methods = this.getStaticMethods(methodName);
        if (!methods.isEmpty()) {
            method = (MetaMethod)this.chooseMethod(methodName, methods, arguments, false);
        }
        if (method == null && this.theClass != Class.class) {
            MetaClass classMetaClass = this.registry.getMetaClass(Class.class);
            method = classMetaClass.pickMethod(methodName, arguments);
        }
        return method;
    }

    public Object invokeConstructor(Object[] arguments) {
        Object firstArgument;
        Class[] argClasses = MetaClassHelper.convertToTypeArray(arguments);
        Constructor constructor = (Constructor)this.chooseMethod("<init>", this.constructors, argClasses, false);
        if (constructor != null) {
            return MetaClassHelper.doConstructorInvoke(constructor, arguments);
        }
        constructor = (Constructor)this.chooseMethod("<init>", this.constructors, argClasses, true);
        if (constructor != null) {
            return MetaClassHelper.doConstructorInvoke(constructor, arguments);
        }
        if (arguments.length == 1 && (firstArgument = arguments[0]) instanceof Map && (constructor = (Constructor)this.chooseMethod("<init>", this.constructors, MetaClassHelper.EMPTY_TYPE_ARRAY, false)) != null) {
            Object bean = MetaClassHelper.doConstructorInvoke(constructor, MetaClassHelper.EMPTY_ARRAY);
            this.setProperties(bean, (Map)firstArgument);
            return bean;
        }
        throw new GroovyRuntimeException("Could not find matching constructor for: " + this.theClass.getName() + "(" + InvokerHelper.toTypeString(arguments) + ")");
    }

    public Object invokeConstructorAt(Class at, Object[] arguments) {
        Object firstArgument;
        Class[] argClasses = MetaClassHelper.convertToTypeArray(arguments);
        Constructor constructor = (Constructor)this.chooseMethod("<init>", this.constructors, argClasses, false);
        if (constructor != null) {
            return MetaClassImpl.doConstructorInvokeAt(at, constructor, arguments);
        }
        constructor = (Constructor)this.chooseMethod("<init>", this.constructors, argClasses, true);
        if (constructor != null) {
            return MetaClassImpl.doConstructorInvokeAt(at, constructor, arguments);
        }
        if (arguments.length == 1 && (firstArgument = arguments[0]) instanceof Map && (constructor = (Constructor)this.chooseMethod("<init>", this.constructors, MetaClassHelper.EMPTY_TYPE_ARRAY, false)) != null) {
            Object bean = MetaClassImpl.doConstructorInvokeAt(at, constructor, MetaClassHelper.EMPTY_ARRAY);
            this.setProperties(bean, (Map)firstArgument);
            return bean;
        }
        throw new GroovyRuntimeException("Could not find matching constructor for: " + this.theClass.getName() + "(" + InvokerHelper.toTypeString(arguments) + ")");
    }

    public void setProperties(Object bean, Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = entry.getKey().toString();
            if (this.propertyMap.get(key) == null) continue;
            Object value = entry.getValue();
            try {
                this.setProperty(bean, key, value);
            }
            catch (GroovyRuntimeException e) {}
        }
    }

    public Object getProperty(Object object, String property) {
        MetaMethod addListenerMethod;
        List methods;
        MetaProperty mp = (MetaProperty)this.propertyMap.get(property);
        if (mp != null) {
            try {
                return mp.getProperty(object);
            }
            catch (Exception e) {
                throw new GroovyRuntimeException("Cannot read property: " + property);
            }
        }
        if (this.genericGetMethod == null) {
            List possibleGenericMethods = this.getMethods("get");
            if (possibleGenericMethods != null) {
                Iterator i = possibleGenericMethods.iterator();
                while (i.hasNext()) {
                    MetaMethod mmethod = (MetaMethod)i.next();
                    Class[] paramTypes = mmethod.getParameterTypes();
                    if (paramTypes.length != 1 || paramTypes[0] != (class$java$lang$String == null ? MetaClassImpl.class$("java.lang.String") : class$java$lang$String)) continue;
                    Object[] arguments = new Object[]{property};
                    Object answer = MetaClassHelper.doMethodInvoke(object, mmethod, arguments);
                    return answer;
                }
            }
        } else {
            Object[] arguments = new Object[]{property};
            Object answer = MetaClassHelper.doMethodInvoke(object, this.genericGetMethod, arguments);
            if (answer != null) {
                return answer;
            }
        }
        if (!CompilerConfiguration.isJsrGroovy() && !(methods = this.getMethods(property)).isEmpty()) {
            return new MethodClosure(object, property);
        }
        GroovyRuntimeException lastException = null;
        try {
            MetaMethod method;
            if (!(object instanceof Class) && (method = this.findGetter(object, "get" + MetaClassHelper.capitalize(property))) != null) {
                return MetaClassHelper.doMethodInvoke(object, method, MetaClassHelper.EMPTY_ARRAY);
            }
        }
        catch (GroovyRuntimeException e) {
            lastException = e;
        }
        if (this.genericGetMethod != null) {
            return null;
        }
        if (object instanceof Class) {
            return this.getStaticProperty((Class)object, property);
        }
        if (object instanceof Collection) {
            return DefaultGroovyMethods.getAt((Collection)object, property);
        }
        if (object instanceof Object[]) {
            return DefaultGroovyMethods.getAt(Arrays.asList((Object[])object), property);
        }
        if (object instanceof Object) {
            try {
                return this.getAttribute(object, property);
            }
            catch (MissingFieldException mfe) {
                // empty catch block
            }
        }
        if ((addListenerMethod = (MetaMethod)this.listeners.get(property)) != null) {
            return null;
        }
        if (lastException == null) {
            throw new MissingPropertyException(property, this.theClass);
        }
        throw new MissingPropertyException(property, this.theClass, lastException);
    }

    public List getProperties() {
        return new ArrayList(this.propertyMap.values());
    }

    private void setupProperties(PropertyDescriptor[] propertyDescriptors) {
        MetaProperty mp;
        Method method;
        int i;
        Class klass;
        MetaMethod getter = null;
        MetaMethod setter = null;
        for (klass = this.theClass; klass != null; klass = klass.getSuperclass()) {
            final Class clazz = klass;
            Field[] fields = (Field[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz.getDeclaredFields();
                }
            });
            for (i = 0; i < fields.length; ++i) {
                if ((fields[i].getModifiers() & 5) == 0 || this.propertyMap.get(fields[i].getName()) != null) continue;
                this.propertyMap.put(fields[i].getName(), new MetaFieldProperty(fields[i]));
            }
        }
        if (this.theClass.isArray()) {
            this.propertyMap.put("length", this.arrayLengthProperty);
        }
        for (int i2 = 0; i2 < propertyDescriptors.length; ++i2) {
            PropertyDescriptor pd = propertyDescriptors[i2];
            if (pd.getPropertyType() == null) continue;
            method = pd.getReadMethod();
            getter = method != null ? this.findMethod(method) : null;
            method = pd.getWriteMethod();
            setter = method != null ? this.findMethod(method) : null;
            mp = new MetaBeanProperty(pd.getName(), pd.getPropertyType(), getter, setter);
            this.propertyMap.put(pd.getName(), mp);
        }
        for (klass = this.theClass; klass != null; klass = klass.getSuperclass()) {
            final Class clazz = klass;
            Method[] methods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz.getDeclaredMethods();
                }
            });
            for (i = 0; i < methods.length; ++i) {
                MetaBeanProperty mbp;
                String propName;
                if (!Modifier.isPublic(methods[i].getModifiers())) continue;
                method = methods[i];
                String methodName = method.getName();
                if (methodName.startsWith("get") && methodName.length() > 3 && method.getParameterTypes().length == 0) {
                    propName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                    mp = (MetaProperty)this.propertyMap.get(propName);
                    if (mp != null) {
                        if (!(mp instanceof MetaBeanProperty) || ((MetaBeanProperty)mp).getGetter() != null) continue;
                        ((MetaBeanProperty)mp).setGetter(this.findMethod(method));
                        continue;
                    }
                    mbp = new MetaBeanProperty(propName, method.getReturnType(), this.findMethod(method), null);
                    this.propertyMap.put(propName, mbp);
                    continue;
                }
                if (!methodName.startsWith("set") || methodName.length() <= 3 || method.getParameterTypes().length != 1) continue;
                propName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                mp = (MetaProperty)this.propertyMap.get(propName);
                if (mp != null) {
                    if (!(mp instanceof MetaBeanProperty) || ((MetaBeanProperty)mp).getSetter() != null) continue;
                    ((MetaBeanProperty)mp).setSetter(this.findMethod(method));
                    continue;
                }
                mbp = new MetaBeanProperty(propName, method.getParameterTypes()[0], null, this.findMethod(method));
                this.propertyMap.put(propName, mbp);
            }
        }
    }

    public void setProperty(Object object, String property, Object newValue) {
        MetaProperty mp = (MetaProperty)this.propertyMap.get(property);
        if (mp != null) {
            try {
                mp.setProperty(object, newValue);
                return;
            }
            catch (ReadOnlyPropertyException e) {
                throw e;
            }
            catch (TypeMismatchException e) {
                throw e;
            }
            catch (Exception e) {
                Class parameterType;
                if (newValue == null) {
                    return;
                }
                if (newValue instanceof List) {
                    List list = (List)newValue;
                    int params = list.size();
                    Constructor<?>[] constructors = mp.getType().getConstructors();
                    for (int i = 0; i < constructors.length; ++i) {
                        Constructor<?> constructor = constructors[i];
                        if (constructor.getParameterTypes().length != params) continue;
                        Object value = MetaClassHelper.doConstructorInvoke(constructor, list.toArray());
                        mp.setProperty(object, value);
                        return;
                    }
                    parameterType = mp.getType();
                    if (parameterType.isArray()) {
                        Object objArray = MetaClassHelper.asPrimitiveArray(list, parameterType);
                        mp.setProperty(object, objArray);
                        return;
                    }
                }
                if (newValue.getClass().isArray() && mp instanceof MetaBeanProperty) {
                    MetaBeanProperty mbp = (MetaBeanProperty)mp;
                    List<Object> list = Arrays.asList((Object[])newValue);
                    MetaMethod setter = mbp.getSetter();
                    parameterType = setter.getParameterTypes()[0];
                    Class<?> arrayType = parameterType.getComponentType();
                    Object objArray = Array.newInstance(arrayType, list.size());
                    for (int i = 0; i < list.size(); ++i) {
                        List<Object> list2 = Arrays.asList((Object[])list.get(i));
                        Object objArray2 = MetaClassHelper.asPrimitiveArray(list2, arrayType);
                        Array.set(objArray, i, objArray2);
                    }
                    MetaClassHelper.doMethodInvoke(object, setter, new Object[]{objArray});
                    return;
                }
                throw new MissingPropertyException(property, this.theClass, e);
            }
        }
        try {
            MetaMethod addListenerMethod = (MetaMethod)this.listeners.get(property);
            if (addListenerMethod != null && newValue instanceof Closure) {
                Object proxy = MetaClassHelper.createListenerProxy(addListenerMethod.getParameterTypes()[0], property, (Closure)newValue);
                MetaClassHelper.doMethodInvoke(object, addListenerMethod, new Object[]{proxy});
                return;
            }
            if (this.genericSetMethod == null) {
                List possibleGenericMethods = this.getMethods("set");
                if (possibleGenericMethods != null) {
                    Iterator i = possibleGenericMethods.iterator();
                    while (i.hasNext()) {
                        MetaMethod mmethod = (MetaMethod)i.next();
                        Class[] paramTypes = mmethod.getParameterTypes();
                        if (paramTypes.length != 2 || paramTypes[0] != (class$java$lang$String == null ? MetaClassImpl.class$("java.lang.String") : class$java$lang$String)) continue;
                        Object[] arguments = new Object[]{property, newValue};
                        Object answer = MetaClassHelper.doMethodInvoke(object, mmethod, arguments);
                        return;
                    }
                }
            } else {
                Object[] arguments = new Object[]{property, newValue};
                MetaClassHelper.doMethodInvoke(object, this.genericSetMethod, arguments);
                return;
            }
            String method = "set" + MetaClassHelper.capitalize(property);
            try {
                this.invokeMethod(object, method, new Object[]{newValue});
            }
            catch (MissingMethodException e1) {
                this.setAttribute(object, property, newValue);
            }
        }
        catch (GroovyRuntimeException e) {
            throw new MissingPropertyException(property, this.theClass, e);
        }
    }

    public Object getAttribute(final Object object, final String attribute) {
        PrivilegedActionException firstException = null;
        final Class clazz = object instanceof Class ? (Class)object : this.theClass;
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchFieldException, IllegalAccessException {
                    Field field = clazz.getDeclaredField(attribute);
                    field.setAccessible(true);
                    return field.get(object);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            firstException = pae;
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchFieldException, IllegalAccessException {
                        Field field = clazz.getField(attribute);
                        field.setAccessible(true);
                        return field.get(object);
                    }
                });
            }
            catch (PrivilegedActionException pae2) {
                if (firstException.getException() instanceof NoSuchFieldException) {
                    throw new MissingFieldException(attribute, this.theClass);
                }
                throw new RuntimeException(firstException.getException());
            }
        }
    }

    public void setAttribute(final Object object, final String attribute, final Object newValue) {
        PrivilegedActionException firstException = null;
        final Class clazz = object instanceof Class ? (Class)object : this.theClass;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchFieldException, IllegalAccessException {
                    Field field = clazz.getDeclaredField(attribute);
                    field.setAccessible(true);
                    field.set(object, newValue);
                    return null;
                }
            });
            return;
        }
        catch (PrivilegedActionException pae) {
            firstException = pae;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchFieldException, IllegalAccessException {
                        Field field = clazz.getField(attribute);
                        field.setAccessible(true);
                        field.set(object, newValue);
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException pae2) {
                if (firstException.getException() instanceof NoSuchFieldException) {
                    throw new MissingFieldException(attribute, this.theClass);
                }
                throw new RuntimeException(firstException.getException());
            }
        }
    }

    public ClassNode getClassNode() {
        if (this.classNode == null && GroovyObject.class.isAssignableFrom(this.theClass)) {
            String className = this.theClass.getName();
            String groovyFile = className;
            int idx = groovyFile.indexOf(36);
            if (idx > 0) {
                groovyFile = groovyFile.substring(0, idx);
            }
            groovyFile = groovyFile.replace('.', '/') + ".groovy";
            URL url = this.theClass.getClassLoader().getResource(groovyFile);
            if (url == null) {
                url = Thread.currentThread().getContextClassLoader().getResource(groovyFile);
            }
            if (url != null) {
                try {
                    CompilationUnit.ClassgenCallback search = new CompilationUnit.ClassgenCallback(){

                        public void call(ClassVisitor writer, ClassNode node) {
                            if (node.getName().equals(MetaClassImpl.this.theClass.getName())) {
                                MetaClassImpl.this.classNode = node;
                            }
                        }
                    };
                    CompilationUnit unit = new CompilationUnit(new GroovyClassLoader(this.getClass().getClassLoader()));
                    unit.setClassgenCallback(search);
                    unit.addSource(url);
                    unit.compile(7);
                }
                catch (Exception e) {
                    throw new GroovyRuntimeException("Exception thrown parsing: " + groovyFile + ". Reason: " + e, e);
                }
            }
        }
        return this.classNode;
    }

    public String toString() {
        return super.toString() + "[" + this.theClass + "]";
    }

    private void addMethods(final Class theClass, boolean forceOverwrite) {
        Method[] methodArray = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return theClass.getDeclaredMethods();
            }
        });
        for (int i = 0; i < methodArray.length; ++i) {
            Method reflectionMethod = methodArray[i];
            if (reflectionMethod.getName().indexOf(43) >= 0) continue;
            MetaMethod method = this.createMetaMethod(reflectionMethod);
            this.addMethod(method, forceOverwrite);
        }
    }

    private void addMethod(MetaMethod method, boolean forceOverwrite) {
        ArrayList<MetaMethod> list;
        String name = method.getName();
        if (this.isGenericGetMethod(method) && this.genericGetMethod == null) {
            this.genericGetMethod = method;
        } else if (MetaClassHelper.isGenericSetMethod(method) && this.genericSetMethod == null) {
            this.genericSetMethod = method;
        }
        if (method.isStatic()) {
            list = (ArrayList<MetaMethod>)this.staticMethodIndex.get(name);
            if (list == null) {
                list = new ArrayList<MetaMethod>();
                this.staticMethodIndex.put(name, list);
                list.add(method);
            } else if (!MetaClassHelper.containsMatchingMethod(list, method)) {
                list.add(method);
            }
        }
        if ((list = (List)this.methodIndex.get(name)) == null) {
            list = new ArrayList();
            this.methodIndex.put(name, list);
            list.add(method);
        } else if (forceOverwrite) {
            this.removeMatchingMethod(list, method);
            list.add(method);
        } else if (!MetaClassHelper.containsMatchingMethod(list, method)) {
            list.add(method);
        }
    }

    private void removeMatchingMethod(List list, MetaMethod method) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Class[] params2;
            MetaMethod aMethod = (MetaMethod)iter.next();
            Class[] params1 = aMethod.getParameterTypes();
            if (params1.length != (params2 = method.getParameterTypes()).length) continue;
            boolean matches = true;
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            iter.remove();
            return;
        }
    }

    private void addNewStaticMethodsFrom(Class theClass) {
        MetaClass interfaceMetaClass = this.registry.getMetaClass(theClass);
        Iterator iter = interfaceMetaClass.newGroovyMethodsList.iterator();
        while (iter.hasNext()) {
            MetaMethod method = (MetaMethod)iter.next();
            if (this.newGroovyMethodsList.contains(method)) continue;
            this.newGroovyMethodsList.add(method);
            this.addMethod(method, false);
        }
    }

    private Object getStaticProperty(Class aClass, String property) {
        MetaMethod method = this.findStaticGetter(aClass, "get" + MetaClassHelper.capitalize(property));
        if (method != null) {
            return MetaClassHelper.doMethodInvoke(aClass, method, MetaClassHelper.EMPTY_ARRAY);
        }
        try {
            return this.getAttribute(aClass, property);
        }
        catch (MissingFieldException mfe) {
            throw new MissingPropertyException(property, aClass, mfe);
        }
    }

    private MetaMethod findMethod(Method aMethod) {
        List methods = this.getMethods(aMethod.getName());
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            MetaMethod method = (MetaMethod)iter.next();
            if (!method.isMethod(aMethod)) continue;
            return method;
        }
        return new ReflectionMetaMethod(aMethod);
    }

    private MetaMethod findGetter(Object object, String name) {
        List methods = this.getMethods(name);
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            MetaMethod method = (MetaMethod)iter.next();
            if (method.getParameterTypes().length != 0) continue;
            return method;
        }
        return null;
    }

    private MetaMethod findStaticGetter(Class type, String name) {
        List methods = this.getStaticMethods(name);
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            MetaMethod method = (MetaMethod)iter.next();
            if (method.getParameterTypes().length != 0) continue;
            return method;
        }
        try {
            Method method = type.getMethod(name, MetaClassHelper.EMPTY_TYPE_ARRAY);
            if ((method.getModifiers() & 8) != 0) {
                return this.findMethod(method);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object doConstructorInvokeAt(Class at, Constructor constructor, Object[] argumentArray) {
        if (log.isLoggable(Level.FINER)) {
            MetaClassHelper.logMethodCall(constructor.getDeclaringClass(), constructor.getName(), argumentArray);
        }
        try {
            final boolean accessible = MetaClassHelper.accessibleToConstructor(at, constructor);
            final Constructor ctor = constructor;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ctor.setAccessible(accessible);
                    return null;
                }
            });
            return constructor.newInstance(argumentArray);
        }
        catch (InvocationTargetException e) {
            throw new InvokerInvocationException(e);
        }
        catch (IllegalArgumentException e) {
            if (MetaClassHelper.coerceGStrings(argumentArray)) {
                try {
                    return constructor.newInstance(argumentArray);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            throw new GroovyRuntimeException("failed to invoke constructor: " + constructor + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e);
        }
        catch (IllegalAccessException e) {
            throw new GroovyRuntimeException("could not access constructor: " + constructor + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e);
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("failed to invoke constructor: " + constructor + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
    }

    private Object chooseMethod(String methodName, List methods, Class[] arguments, boolean coerce) {
        int methodCount = methods.size();
        if (methodCount <= 0) {
            return null;
        }
        if (methodCount == 1) {
            Object method = methods.get(0);
            if (MetaClassHelper.isValidMethod(method, arguments, coerce)) {
                return method;
            }
            return null;
        }
        Object answer = null;
        if (arguments == null || arguments.length == 0) {
            answer = MetaClassHelper.chooseEmptyMethodParams(methods);
        } else if (arguments.length == 1 && arguments[0] == null) {
            answer = MetaClassHelper.chooseMostGeneralMethodWith1NullParam(methods);
        } else {
            ArrayList matchingMethods = new ArrayList();
            Iterator iter = methods.iterator();
            while (iter.hasNext()) {
                Object method = iter.next();
                if (!MetaClassHelper.isValidMethod(method, arguments, coerce)) continue;
                matchingMethods.add(method);
            }
            if (matchingMethods.isEmpty()) {
                return null;
            }
            if (matchingMethods.size() == 1) {
                return matchingMethods.get(0);
            }
            return this.chooseMostSpecificParams(methodName, matchingMethods, arguments);
        }
        if (answer != null) {
            return answer;
        }
        throw new GroovyRuntimeException("Could not find which method to invoke from this list: " + methods + " for arguments: " + InvokerHelper.toString(arguments));
    }

    private Object chooseMostSpecificParams(String name, List matchingMethods, Class[] arguments) {
        Class[] wrappedArguments = MetaClassHelper.wrap(arguments);
        int matchesDistance = -1;
        LinkedList matches = new LinkedList();
        Iterator iter = matchingMethods.iterator();
        while (iter.hasNext()) {
            Object method = iter.next();
            Class[] paramTypes = MetaClassHelper.getParameterTypes(method);
            if (!MetaClassHelper.parametersAreCompatible(arguments, paramTypes)) continue;
            int dist = MetaClassHelper.calculateParameterDistance(arguments, paramTypes);
            if (matches.size() == 0) {
                matches.add(method);
                matchesDistance = dist;
                continue;
            }
            if (dist < matchesDistance) {
                matchesDistance = dist;
                matches.clear();
                matches.add(method);
                continue;
            }
            if (dist != matchesDistance) continue;
            matches.add(method);
        }
        if (matches.size() == 1) {
            return matches.getFirst();
        }
        if (matches.size() == 0) {
            return null;
        }
        String msg = "Ambiguous method overloading for method ";
        msg = msg + this.theClass.getName() + "#" + name;
        msg = msg + ".\nCannot resolve which method to invoke for ";
        msg = msg + InvokerHelper.toString(arguments);
        msg = msg + " due to overlapping prototypes between:";
        Iterator iter2 = matches.iterator();
        while (iter2.hasNext()) {
            Class[] types = MetaClassHelper.getParameterTypes(iter2.next());
            msg = msg + "\n\t" + InvokerHelper.toString(types);
        }
        throw new GroovyRuntimeException(msg);
    }

    private boolean isGenericGetMethod(MetaMethod method) {
        if (method.getName().equals("get")) {
            Class[] parameterTypes = method.getParameterTypes();
            return parameterTypes.length == 1 && parameterTypes[0] == String.class;
        }
        return false;
    }

    private synchronized void onMethodChange() {
        this.reflector = null;
    }

    protected synchronized void checkInitialised() {
        if (!this.initialised) {
            this.initialised = true;
            this.addInheritedMethods();
        }
        if (this.reflector == null) {
            this.generateReflector();
        }
    }

    private MetaMethod createMetaMethod(final Method method) {
        MetaMethod answer;
        if (this.registry.useAccessible()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    method.setAccessible(true);
                    return null;
                }
            });
        }
        if (this.isValidReflectorMethod(answer = new MetaMethod(method))) {
            this.allMethods.add(answer);
            answer.setMethodIndex(this.allMethods.size());
        } else {
            answer = new ReflectionMetaMethod(method);
        }
        if (useReflection) {
            return new ReflectionMetaMethod(method);
        }
        return answer;
    }

    private boolean isValidReflectorMethod(MetaMethod method) {
        Class declaringClass;
        if (!method.isPublic()) {
            return false;
        }
        List interfaceMethods = this.getInterfaceMethods();
        Iterator iter = interfaceMethods.iterator();
        while (iter.hasNext()) {
            MetaMethod aMethod = (MetaMethod)iter.next();
            if (!method.isSame(aMethod)) continue;
            method.setInterfaceClass(aMethod.getDeclaringClass());
            return true;
        }
        for (Class clazz = declaringClass = method.getDeclaringClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                final Class klazz = clazz;
                final String mName = method.getName();
                final Class[] parms = method.getParameterTypes();
                try {
                    Method m = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws NoSuchMethodException {
                            return klazz.getDeclaredMethod(mName, parms);
                        }
                    });
                    if (!Modifier.isPublic(clazz.getModifiers()) || !Modifier.isPublic(m.getModifiers())) continue;
                    declaringClass = clazz;
                    continue;
                }
                catch (PrivilegedActionException pae) {
                    if (pae.getException() instanceof NoSuchMethodException) {
                        throw (NoSuchMethodException)pae.getException();
                    }
                    throw new RuntimeException(pae.getException());
                }
            }
            catch (SecurityException e) {
                continue;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (!Modifier.isPublic(declaringClass.getModifiers())) {
            return false;
        }
        method.setDeclaringClass(declaringClass);
        return true;
    }

    private void generateReflector() {
        this.reflector = this.loadReflector(this.allMethods);
        if (this.reflector == null) {
            throw new RuntimeException("Should have a reflector for " + this.theClass.getName());
        }
        Iterator iter = this.allMethods.iterator();
        while (iter.hasNext()) {
            MetaMethod metaMethod = (MetaMethod)iter.next();
            metaMethod.setReflector(this.reflector);
        }
    }

    private String getReflectorName() {
        String className = this.theClass.getName();
        String packagePrefix = "gjdk.";
        String name = packagePrefix + className + "_GroovyReflector";
        if (this.theClass.isArray()) {
            Class<?> clazz = this.theClass;
            name = packagePrefix;
            int level = 0;
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
                ++level;
            }
            String componentName = clazz.getName();
            name = packagePrefix + componentName + "_GroovyReflectorArray";
            if (level > 1) {
                name = name + level;
            }
        }
        return name;
    }

    private Reflector loadReflector(List methods) {
        ReflectorGenerator generator = new ReflectorGenerator(methods);
        String name = this.getReflectorName();
        try {
            Class type = this.loadReflectorClass(name);
            return (Reflector)type.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            try {
                ClassWriter cw = new ClassWriter(true);
                generator.generate(cw, name);
                byte[] bytecode = cw.toByteArray();
                Class type = this.loadReflectorClass(name, bytecode);
                if (Reflector.class.getClassLoader() != type.getSuperclass().getClassLoader()) {
                    throw new Error(name + " does have Reflector.class as superclass, " + "Reflector.class is loaded through the loader " + Reflector.class.getClassLoader() + " and " + name + "'s superclass is loaded through " + type.getSuperclass().getClassLoader() + ". This should never happen, check your classloader configuration.");
                }
                return (Reflector)type.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new GroovyRuntimeException("Could not generate and load the reflector for class: " + name + ". Reason: " + e, e);
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new GroovyRuntimeException("Could not load the reflector for class: " + name + ". Reason: " + t, t);
        }
    }

    private Class loadReflectorClass(final String name, final byte[] bytecode) throws ClassNotFoundException {
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MetaClassImpl.this.theClass.getClassLoader();
            }
        });
        if (loader instanceof GroovyClassLoader) {
            final GroovyClassLoader gloader = (GroovyClassLoader)loader;
            return (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return gloader.defineClass(name, bytecode, this.getClass().getProtectionDomain());
                }
            });
        }
        return this.registry.loadClass(loader, name, bytecode);
    }

    private Class loadReflectorClass(String name) throws ClassNotFoundException {
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MetaClassImpl.this.theClass.getClassLoader();
            }
        });
        if (loader instanceof GroovyClassLoader) {
            GroovyClassLoader gloader = (GroovyClassLoader)loader;
            return gloader.loadClass(name);
        }
        return this.registry.loadClass(loader, name);
    }

    public List getMethods() {
        return this.allMethods;
    }

    public List getMetaMethods() {
        return new ArrayList(this.newGroovyMethodsList);
    }

    private synchronized List getInterfaceMethods() {
        if (this.interfaceMethods == null) {
            this.interfaceMethods = new ArrayList();
            for (Class type = this.theClass; type != null; type = type.getSuperclass()) {
                Class<?>[] interfaces = type.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    Class<?> iface = interfaces[i];
                    Method[] methods = iface.getMethods();
                    this.addInterfaceMethods(this.interfaceMethods, methods);
                }
            }
        }
        return this.interfaceMethods;
    }

    private void addInterfaceMethods(List list, Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            list.add(this.createMetaMethod(methods[i]));
        }
    }
}

