/*
 * Decompiled with CFR 0.152.
 */
package groovy.util.slurpersupport;

import groovy.lang.Buildable;
import groovy.lang.Closure;
import groovy.lang.DelegatingMetaClass;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MetaClass;
import groovy.lang.Writable;
import groovy.util.slurpersupport.Attributes;
import groovy.util.slurpersupport.NodeChildren;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public abstract class GPathResult
extends GroovyObjectSupport
implements Writable,
Buildable {
    protected final GPathResult parent;
    protected final String name;
    protected final String namespacePrefix;
    protected final Map namespaceMap = new HashMap();
    protected final Map namespaceTagHints;

    public GPathResult(GPathResult parent, String name, String namespacePrefix, Map namespaceTagHints) {
        if (parent == null) {
            this.parent = this;
            this.namespaceMap.put("xml", "http://www.w3.org/XML/1998/namespace");
        } else {
            this.parent = parent;
            this.namespaceMap.putAll(parent.namespaceMap);
        }
        this.name = name;
        this.namespacePrefix = namespacePrefix;
        this.namespaceTagHints = namespaceTagHints;
        this.setMetaClass(this.getMetaClass());
    }

    public void setMetaClass(MetaClass metaClass) {
        DelegatingMetaClass newMetaClass = new DelegatingMetaClass(metaClass){

            public Object getAttribute(Object object, String attribute) {
                return GPathResult.this.getProperty("@" + attribute);
            }
        };
        super.setMetaClass(newMetaClass);
    }

    public Object getProperty(String property) {
        if ("..".equals(property)) {
            return this.parent();
        }
        if ("*".equals(property)) {
            return this.children();
        }
        if ("**".equals(property)) {
            return this.depthFirst();
        }
        if (property.startsWith("@")) {
            if (property.indexOf(":") != -1) {
                int i = property.indexOf(":");
                return new Attributes(this, "@" + property.substring(i + 1), property.substring(1, i), this.namespaceTagHints);
            }
            return new Attributes(this, property, this.namespaceTagHints);
        }
        if (property.indexOf(":") != -1) {
            int i = property.indexOf(":");
            return new NodeChildren(this, property.substring(i + 1), property.substring(0, i), this.namespaceTagHints);
        }
        return new NodeChildren(this, property, this.namespaceTagHints);
    }

    public String name() {
        return this.name;
    }

    public GPathResult parent() {
        return this.parent;
    }

    public GPathResult children() {
        return new NodeChildren(this, this.namespaceTagHints);
    }

    public String toString() {
        return this.text();
    }

    public GPathResult declareNamespace(Map newNamespaceMapping) {
        this.namespaceMap.putAll(newNamespaceMapping);
        return this;
    }

    public boolean equals(Object obj) {
        return this.text().equals(obj.toString());
    }

    public Object getAt(int index) {
        Iterator iter = this.iterator();
        int count = 0;
        while (iter.hasNext()) {
            if (count++ == index) {
                return iter.next();
            }
            iter.next();
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public Iterator depthFirst() {
        return new Iterator(){
            private final Stack stack = new Stack();
            private Iterator iter = GPathResult.this.iterator();
            private GPathResult next = this.getNextByDepth();

            public boolean hasNext() {
                return this.next != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object next() {
                try {
                    GPathResult gPathResult = this.next;
                    return gPathResult;
                }
                finally {
                    this.next = this.getNextByDepth();
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            private GPathResult getNextByDepth() {
                while (this.iter.hasNext()) {
                    GPathResult node = (GPathResult)this.iter.next();
                    this.stack.push(node);
                    this.stack.push(this.iter);
                    this.iter = node.children().iterator();
                }
                if (this.stack.empty()) {
                    return null;
                }
                this.iter = (Iterator)this.stack.pop();
                return (GPathResult)this.stack.pop();
            }
        };
    }

    public List list() {
        Iterator iter = this.nodeIterator();
        LinkedList result = new LinkedList();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public abstract int size();

    public abstract String text();

    public abstract GPathResult parents();

    public abstract Iterator childNodes();

    public abstract Iterator iterator();

    public abstract GPathResult find(Closure var1);

    public abstract GPathResult findAll(Closure var1);

    public abstract Iterator nodeIterator();
}

