/*
 * Decompiled with CFR 0.152.
 */
package gs.hitchin.hitchfs;

import gs.hitchin.hitchfs.FakeFile;
import gs.hitchin.hitchfs.StubFileSystem;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class BasicFileSystem
extends StubFileSystem {
    @Override
    public String getPath(FakeFile fake) {
        return fake.getPathField();
    }

    @Override
    public String toString(FakeFile fake) {
        return fake.getPath();
    }

    @Override
    public String getAbsolutePath(FakeFile fake) {
        return this.absolute(fake.getPath());
    }

    @Override
    public File getAbsoluteFile(FakeFile fake) {
        return this.file(fake.getAbsolutePath());
    }

    @Override
    public String getParent(FakeFile fake) {
        int index;
        String path = fake.getPath();
        int length = path.length();
        int firstInPath = 0;
        if (this.getSeparatorChar() == '\\' && length > 2 && path.charAt(1) == ':') {
            firstInPath = 2;
        }
        if ((index = path.lastIndexOf(this.getSeparatorChar())) == -1 && firstInPath > 0) {
            index = 2;
        }
        if (index == -1 || path.charAt(length - 1) == this.getSeparatorChar()) {
            return null;
        }
        if (path.indexOf(this.getSeparatorChar()) == index && path.charAt(firstInPath) == this.getSeparatorChar()) {
            return path.substring(0, index + 1);
        }
        return path.substring(0, index);
    }

    @Override
    public File getParentFile(FakeFile fake) {
        String parent = fake.getParent();
        if (parent != null) {
            return this.file(parent);
        }
        return null;
    }

    @Override
    public String getCanonicalPath(FakeFile fake) throws IOException {
        return this.canonical(fake.getPath());
    }

    @Override
    public File getCanonicalFile(FakeFile fake) throws IOException {
        return this.file(fake.getCanonicalPath());
    }

    @Override
    public String getName(FakeFile fake) {
        String path = fake.getPath();
        int separatorIndex = path.lastIndexOf(this.separator);
        return separatorIndex < 0 ? path : path.substring(separatorIndex + 1, path.length());
    }

    @Override
    public boolean isAbsolute(FakeFile fake) {
        return this.isAbsolute(fake.getPath());
    }

    @Override
    public int compareTo(FakeFile fake, File pathname) {
        return fake.getAbsolutePath().compareTo(pathname.getAbsolutePath());
    }

    @Override
    public boolean equals(FakeFile fake, Object obj) {
        if (!(obj instanceof File)) {
            return false;
        }
        String path = fake.getPath();
        if (!this.caseSensitive) {
            return path.equalsIgnoreCase(((File)obj).getPath());
        }
        return path.equals(((File)obj).getPath());
    }

    @Override
    public int hashCode(FakeFile fake) {
        String path = fake.getPath();
        if (this.caseSensitive) {
            return path.hashCode() ^ 0x12D591;
        }
        return path.toLowerCase().hashCode() ^ 0x12D591;
    }

    @Override
    public URI toURI(FakeFile fake) {
        String name = fake.getAbsolutePath();
        try {
            if (!name.startsWith("/")) {
                return new URI("file", null, new StringBuilder(name.length() + 1).append('/').append(name).toString(), null, null);
            }
            if (name.startsWith("//")) {
                return new URI("file", "", name, null);
            }
            return new URI("file", null, name, null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public URL toURL(FakeFile fake) throws MalformedURLException {
        String name = fake.getAbsolutePath();
        if (!name.startsWith("/")) {
            return new URL("file", "", -1, new StringBuilder(name.length() + 1).append('/').append(name).toString(), null);
        }
        if (name.startsWith("//")) {
            return new URL("file:" + name);
        }
        return new URL("file", "", -1, name, null);
    }
}

