/*
 * Decompiled with CFR 0.152.
 */
package gs.hitchin.hitchfs;

import gs.hitchin.hitchfs.FakeFile;
import gs.hitchin.hitchfs.IOFileSystem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArrayContent
implements IOFileSystem.FileContent {
    ByteArrayOutputStream output = null;
    byte[] data = new byte[0];

    public ByteArrayContent() {
    }

    public ByteArrayContent(byte[] data) {
        this.data = data;
    }

    @Override
    public void clear() {
        this.data = new byte[0];
        this.output = null;
    }

    @Override
    public InputStream getInputStream(IOFileSystem.Content content, FakeFile fake) {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public OutputStream getOutputStream(IOFileSystem.Content content, FakeFile fake, boolean append) throws IOException {
        if (append) {
            this.output = new ByteArrayOutputStream(this.data.length);
            this.output.write(this.data);
        } else {
            this.output = new ByteArrayOutputStream();
        }
        this.data = new byte[0];
        return this.output;
    }

    @Override
    public void close() {
        if (this.output != null) {
            this.data = this.output.toByteArray();
        }
    }

    public static IOFileSystem.Content byteArrayContent() {
        return ByteArrayContent.byteArrayContent(new byte[0]);
    }

    public static IOFileSystem.Content byteArrayContent(CharSequence data) {
        byte[] bs = new byte[data.length()];
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)data.charAt(i);
        }
        return new IOFileSystem.Content(new ByteArrayContent(bs));
    }

    public static IOFileSystem.Content byteArrayContent(byte[] data) {
        return new IOFileSystem.Content(new ByteArrayContent(data));
    }
}

