/*
 * Decompiled with CFR 0.152.
 */
package gs.hitchin.hitchfs;

import gs.hitchin.hitchfs.FakeFile;
import gs.hitchin.hitchfs.FileProp;
import gs.hitchin.hitchfs.Md5Content;
import gs.hitchin.hitchfs.MemoryFileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class IOFileSystem
extends MemoryFileSystem {
    @Override
    public OutputStream getOutputStream(FakeFile fake, boolean append) throws IOException {
        if (fake.exists() && !fake.canWrite()) {
            throw new IOException("No write permission.");
        }
        if (fake.isDirectory()) {
            throw new IOException("Cannot write to a directory.");
        }
        fake.createNewFile();
        Content content = this.getContent(fake);
        return content.getOutputStream(fake, append);
    }

    @Override
    public InputStream getInputStream(FakeFile fake) throws IOException {
        if (!fake.exists()) {
            throw new FileNotFoundException(fake.getPath() + " not found.");
        }
        if (!fake.canRead()) {
            throw new IOException("No read permission.");
        }
        if (fake.isDirectory()) {
            throw new IOException("Cannot read a directory.");
        }
        Content content = this.getContent(fake);
        return content.getInputStream(fake);
    }

    @Override
    public long length(FakeFile fake) {
        if (!fake.exists()) {
            return 0L;
        }
        return this.getContent(fake).getLength();
    }

    @Override
    public boolean delete(FakeFile fake) {
        boolean r = super.delete(fake);
        if (r) {
            this.getContent(fake).clear();
        }
        return r;
    }

    Content getContent(FakeFile fake) {
        Content c = fake.getProperty(Content.class);
        if (c == null) {
            c = new Content();
            fake.withProperty(c);
        }
        return c;
    }

    static class ContentInputStream
    extends InputStream {
        private Content content;
        private InputStream input;
        private FakeFile fake;

        public ContentInputStream(Content content, FakeFile fake, InputStream input) throws IOException {
            this.content = content;
            this.fake = fake;
            this.input = input;
            content.open(fake, FileState.READING);
        }

        @Override
        public int read() throws IOException {
            return this.input.read();
        }

        @Override
        public void close() throws IOException {
            this.content.close(this.fake, FileState.READING, false);
        }
    }

    static class ContentOutputStream
    extends OutputStream {
        private Content content;
        private FakeFile fake;
        private OutputStream output;

        public ContentOutputStream(Content content, FakeFile fake, OutputStream output) throws IOException {
            this.content = content;
            this.output = output;
            this.fake = fake;
            content.open(fake, FileState.WRITING);
        }

        @Override
        public void write(int b) throws IOException {
            this.output.write(b);
            this.content.incLength();
        }

        @Override
        public void close() throws IOException {
            this.content.close(this.fake, FileState.WRITING, true);
        }
    }

    static enum FileState {
        NONE,
        READING,
        WRITING;

    }

    static class Content
    implements FileProp {
        AtomicReference<FileState> state = new AtomicReference<FileState>(FileState.NONE);
        FileContent content = new Md5Content();
        AtomicLong length = new AtomicLong(0L);

        public Content() {
        }

        public Content(FileContent content) {
            this.content = content;
        }

        public OutputStream getOutputStream(FakeFile fake, boolean append) throws IOException {
            ContentOutputStream out = new ContentOutputStream(this, fake, this.content.getOutputStream(this, fake, append));
            if (!append) {
                this.length.set(0L);
            }
            return out;
        }

        public long getLength() {
            if (this.state.get() == FileState.NONE) {
                return this.length.get();
            }
            return 0L;
        }

        public void setLength(long length) {
            this.length.set(length);
        }

        public long incLength() {
            return this.length.incrementAndGet();
        }

        public InputStream getInputStream(FakeFile fake) throws IOException {
            return new ContentInputStream(this, fake, this.content.getInputStream(this, fake));
        }

        public void clear() {
            this.content.clear();
            this.length.set(0L);
            this.state.set(FileState.NONE);
        }

        public void open(FakeFile fake, FileState newState) throws IOException {
            if (!this.state.compareAndSet(FileState.NONE, newState)) {
                throw new IOException(String.format("File is already open for %s.", new Object[]{this.state.get()}));
            }
        }

        public void close(FakeFile fake, FileState expectedState, boolean updateLastModified) throws IOException {
            this.content.close();
            if (!this.state.compareAndSet(expectedState, FileState.NONE)) {
                throw new IOException(String.format("File was changed from %s state before close.", this.state));
            }
            if (updateLastModified) {
                fake.touch();
            }
        }

        public FileContent getContent() {
            return this.content;
        }
    }

    static interface FileContent {
        public InputStream getInputStream(Content var1, FakeFile var2) throws IOException;

        public OutputStream getOutputStream(Content var1, FakeFile var2, boolean var3) throws IOException;

        public void close();

        public void clear();
    }
}

