/*
 * Decompiled with CFR 0.152.
 */
package gs.hitchin.hitchfs;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import gs.hitchin.hitchfs.BasicFileSystem;
import gs.hitchin.hitchfs.FakeFile;
import gs.hitchin.hitchfs.FileProp;
import gs.hitchin.hitchfs.PropStore;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MemoryFileSystem
extends BasicFileSystem {
    Node root = new Node();

    public MemoryFileSystem() {
        this.getMetadata(this.root).setExists(true).setFile(false).setLastModified(this.currentTimeMillis());
        this.file(this.getCurrentDirectory()).mkdirs();
    }

    @Override
    public FakeFile register(FakeFile file) {
        Node current = this.lookup(file);
        if (current.props == null) {
            current.props = file.getProperties();
        } else {
            file.setProperties(current.props);
        }
        return file;
    }

    public Node lookup(FakeFile file) {
        Node current = this.root;
        for (String p : this.canonicalSplit(file.getPath())) {
            current = current.get(p);
        }
        return current;
    }

    @Override
    public boolean exists(FakeFile fake) {
        return this.getMetadata((FakeFile)fake).exists;
    }

    @Override
    public boolean mkdir(FakeFile fake) {
        try {
            File parent = fake.getCanonicalFile().getParentFile();
            if (parent == null) {
                return false;
            }
            if (!parent.exists()) {
                return false;
            }
            if (!parent.canWrite()) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        if (fake.exists()) {
            return false;
        }
        this.getMetadata(fake).setExists(true).setFile(false);
        this.touch(fake);
        return true;
    }

    @Override
    public boolean mkdirs(FakeFile fake) {
        if (fake.exists()) {
            return false;
        }
        if (fake.mkdir()) {
            return true;
        }
        String parentDir = fake.getParent();
        if (parentDir == null) {
            return false;
        }
        return this.file(parentDir).mkdirs() && fake.mkdir();
    }

    @Override
    public boolean isDirectory(FakeFile fake) {
        return fake.exists() && !this.getMetadata((FakeFile)fake).isFile;
    }

    @Override
    public boolean isFile(FakeFile fake) {
        return fake.exists() && this.getMetadata((FakeFile)fake).isFile;
    }

    @Override
    public boolean createNewFile(FakeFile fake) throws IOException {
        try {
            File f = fake.getCanonicalFile().getParentFile();
            if (!f.exists()) {
                return false;
            }
            if (!f.canWrite()) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        if (fake.exists()) {
            return false;
        }
        this.getMetadata(fake).setExists(true).setFile(true);
        this.touch(fake);
        return true;
    }

    @Override
    public boolean delete(FakeFile fake) {
        if (!fake.exists()) {
            return false;
        }
        try {
            File f = fake.getCanonicalFile().getParentFile();
            if (!f.canWrite()) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        if (!fake.canWrite()) {
            return false;
        }
        if (fake.isFile()) {
            this.getMetadata(fake).setDefaults();
            return true;
        }
        String[] contents = fake.list();
        if (contents != null && contents.length == 0) {
            this.getMetadata(fake).setDefaults();
            return true;
        }
        return false;
    }

    public List<String> listAsList(FakeFile fake) {
        if (fake.isFile() || !fake.canRead()) {
            return null;
        }
        Node n = this.lookup(fake);
        ArrayList rs = Lists.newArrayListWithExpectedSize((int)n.nodes.size());
        for (Map.Entry<String, Node> e : n.nodes.entrySet()) {
            if (!this.getMetadata((Node)e.getValue()).exists) continue;
            rs.add(e.getKey());
        }
        Collections.sort(rs);
        return rs;
    }

    @Override
    public String[] list(FakeFile fake) {
        List<String> rs = this.listAsList(fake);
        if (rs == null) {
            return null;
        }
        return rs.toArray(new String[rs.size()]);
    }

    @Override
    public File[] listFiles(FakeFile fake) {
        return this.toFiles(fake, fake.list());
    }

    @Override
    public String[] list(final FakeFile fake, final FilenameFilter filter) {
        List<String> list = this.listAsList(fake);
        if (list == null) {
            return null;
        }
        ImmutableList rs = ImmutableList.copyOf((Iterable)Iterables.filter(list, (Predicate)new Predicate<String>(){

            public boolean apply(String name) {
                return filter.accept(fake, name);
            }
        }));
        return rs.toArray(new String[rs.size()]);
    }

    public File[] listFiles(final FakeFile dir, Predicate<File> filter) {
        List<String> list = this.listAsList(dir);
        if (list == null) {
            return null;
        }
        ImmutableList rs = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Lists.transform(list, (Function)new Function<String, File>(){

            public File apply(String name) {
                return MemoryFileSystem.this.file(dir, name);
            }
        }), filter));
        return rs.toArray(new File[rs.size()]);
    }

    @Override
    public File[] listFiles(FakeFile dir, final FileFilter filter) {
        return this.listFiles(dir, new Predicate<File>(){

            public boolean apply(File f) {
                return filter.accept(f);
            }
        });
    }

    @Override
    public File[] listFiles(final FakeFile dir, final FilenameFilter filter) {
        return this.listFiles(dir, new Predicate<File>(){

            public boolean apply(File f) {
                return filter.accept(dir, f.getName());
            }
        });
    }

    private File[] toFiles(FakeFile dir, String[] files) {
        if (files == null) {
            return null;
        }
        File[] result = new File[files.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.file(dir, files[i]);
        }
        return result;
    }

    @Override
    public void deleteOnExit(FakeFile fake) {
        this.getMetadata(fake).setDeleteOnExit(true);
    }

    @Override
    public boolean renameTo(FakeFile fake, File dest) {
        if (!fake.exists()) {
            return false;
        }
        FakeFile d = this.file(dest);
        if (d.exists()) {
            return false;
        }
        PropStore oldProps = fake.getProperties();
        PropStore newProps = d.getProperties();
        HashMap newHashMap = Maps.newHashMap();
        newProps.setMap(oldProps.setMap(newHashMap));
        Node oNode = this.lookup(fake);
        Node nNode = this.lookup(d);
        nNode.nodes = oNode.nodes;
        oNode.nodes = Maps.newHashMap();
        return true;
    }

    @Override
    public void setHidden(FakeFile fake, boolean hidden) {
        if (fake.exists()) {
            this.getMetadata(fake).setHidden(hidden);
        }
    }

    @Override
    public boolean isHidden(FakeFile fake) {
        return fake.exists() && this.getMetadata((FakeFile)fake).hidden;
    }

    @Override
    public long lastModified(FakeFile fake) {
        if (fake.exists()) {
            return this.getMetadata((FakeFile)fake).lastModified;
        }
        return 0L;
    }

    @Override
    public boolean setLastModified(FakeFile fake, long millis) {
        if (!fake.exists()) {
            return false;
        }
        this.getMetadata(fake).setLastModified(millis);
        return true;
    }

    @Override
    public void touch(FakeFile fake) {
        fake.setLastModified(this.currentTimeMillis());
    }

    @Override
    public File[] listRoots() {
        return new File[]{this.file("/")};
    }

    @Override
    public boolean setWritable(FakeFile fake, boolean writable, boolean ownerOnly) {
        if (!fake.exists()) {
            return false;
        }
        if (this.isOwner(fake)) {
            Metadata meta = this.getMetadata(fake);
            if (ownerOnly) {
                meta.setWritable(writable, meta.allWrite);
            } else {
                meta.setWritable(writable, writable);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setReadable(FakeFile fake, boolean readable, boolean ownerOnly) {
        if (!fake.exists()) {
            return false;
        }
        if (this.isOwner(fake)) {
            Metadata meta = this.getMetadata(fake);
            if (ownerOnly) {
                meta.setReadable(readable, meta.allRead);
            } else {
                meta.setReadable(readable, readable);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setReadOnly(FakeFile fake) {
        return this.setReadable(fake, false);
    }

    @Override
    public boolean setExecutable(FakeFile fake, boolean executable, boolean ownerOnly) {
        if (!fake.exists()) {
            return false;
        }
        if (this.isOwner(fake)) {
            Metadata meta = this.getMetadata(fake);
            if (ownerOnly) {
                meta.setExecutable(executable, meta.allExecute);
            } else {
                meta.setExecutable(executable, executable);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canRead(FakeFile fake) {
        if (!fake.exists()) {
            return false;
        }
        Metadata meta = this.getMetadata(fake);
        if (this.isOwner(fake)) {
            return meta.ownerRead;
        }
        return meta.allRead;
    }

    @Override
    public boolean canWrite(FakeFile fake) {
        if (!fake.exists()) {
            return false;
        }
        Metadata meta = this.getMetadata(fake);
        if (this.isOwner(fake)) {
            return meta.ownerWrite;
        }
        return meta.allWrite;
    }

    @Override
    public boolean canExecute(FakeFile fake) {
        if (!fake.exists()) {
            return false;
        }
        Metadata meta = this.getMetadata(fake);
        if (this.isOwner(fake)) {
            return meta.ownerExecute;
        }
        return meta.allExecute;
    }

    @Override
    public boolean setWritable(FakeFile fake, boolean writable) {
        return this.setWritable(fake, writable, true);
    }

    @Override
    public boolean setExecutable(FakeFile fake, boolean executable) {
        return this.setExecutable(fake, executable, true);
    }

    @Override
    public boolean setReadable(FakeFile fake, boolean readable) {
        return this.setReadable(fake, readable, true);
    }

    public boolean isOwner(FakeFile fake) {
        return true;
    }

    Metadata getMetadata(Node node) {
        Metadata meta;
        PropStore props = node.props;
        if (props == null) {
            props = node.props = new PropStore();
        }
        if ((meta = props.getProperty(Metadata.class)) == null) {
            meta = new Metadata();
            props.withProperty(meta);
        }
        return meta;
    }

    Metadata getMetadata(FakeFile fake) {
        Metadata meta = fake.getProperty(Metadata.class);
        if (meta == null) {
            meta = this.getMetadata(this.lookup(fake));
            fake.withProperty(meta);
        }
        return meta;
    }

    public void printFS() {
        this.printFS(0, "/", this.root);
    }

    private void printFS(int indent, String path, Node node) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("  ");
        }
        System.out.print("- " + path);
        if (node.props != null && node.props.hasProperty(Metadata.class)) {
            Metadata meta = node.props.getProperty(Metadata.class);
            System.out.print(" [" + meta + "]");
        }
        System.out.println();
        List files = Ordering.natural().sortedCopy(node.nodes.keySet());
        for (String f : files) {
            this.printFS(indent + 1, f, node.get(f));
        }
    }

    static class Metadata
    implements FileProp {
        boolean exists = false;
        boolean isFile = false;
        boolean ownerRead = true;
        boolean ownerWrite = true;
        boolean ownerExecute = true;
        boolean allRead = true;
        boolean allWrite = true;
        boolean allExecute = true;
        boolean deleteOnExit = false;
        boolean hidden = false;
        long lastModified = 0L;

        Metadata() {
        }

        public Metadata setDefaults() {
            this.exists = false;
            this.isFile = false;
            this.ownerRead = true;
            this.ownerWrite = true;
            this.ownerExecute = true;
            this.allRead = true;
            this.allWrite = true;
            this.allExecute = true;
            this.deleteOnExit = false;
            this.hidden = false;
            this.lastModified = 0L;
            return this;
        }

        public Metadata setReadable(boolean ownerRead, boolean allRead) {
            this.ownerRead = ownerRead;
            this.allRead = allRead;
            return this;
        }

        public Metadata setWritable(boolean ownerWrite, boolean allWrite) {
            this.ownerWrite = ownerWrite;
            this.allWrite = allWrite;
            return this;
        }

        public Metadata setExecutable(boolean ownerExecute, boolean allExecute) {
            this.ownerExecute = ownerExecute;
            this.allExecute = allExecute;
            return this;
        }

        public Metadata setLastModified(long millis) {
            this.lastModified = millis;
            return this;
        }

        public Metadata setHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Metadata setExists(boolean exists) {
            this.exists = exists;
            return this;
        }

        public Metadata setFile(boolean isFile) {
            this.isFile = isFile;
            return this;
        }

        public Metadata setDeleteOnExit(boolean deleteOnExit) {
            this.deleteOnExit = deleteOnExit;
            return this;
        }
    }

    static class Node {
        PropStore props;
        Map<String, Node> nodes = Maps.newHashMap();

        Node() {
        }

        Node get(String name) {
            Node n = this.nodes.get(name);
            if (n == null) {
                n = new Node();
                this.nodes.put(name, n);
            }
            return n;
        }
    }
}

