/*
 * Decompiled with CFR 0.152.
 */
package gs.hitchin.hitchfs;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageDigestOutputStream
extends OutputStream {
    private final MessageDigest digest;
    private byte[] bytes;
    private boolean closed;
    private OutputStream output;

    public MessageDigestOutputStream(MessageDigest digest) {
        this.digest = digest;
    }

    @Override
    public void write(int b) throws IOException {
        this.digest.update((byte)(0xFF & b));
        if (this.output != null) {
            this.output.write(b);
        }
    }

    public byte[] getDigest() {
        if (this.bytes == null) {
            this.bytes = this.digest.digest();
        }
        return this.bytes;
    }

    public String getDigestAsHex() {
        StringBuilder hexString = new StringBuilder();
        for (byte b : this.getDigest()) {
            hexString.append(String.format("%02x", b));
        }
        return hexString.toString();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.output != null) {
            this.output.close();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public MessageDigestOutputStream setOutput(OutputStream output) {
        this.output = output;
        return this;
    }

    public boolean isEqual(byte[] expected) {
        return MessageDigest.isEqual(this.getDigest(), expected);
    }

    public static MessageDigestOutputStream output(String algo) {
        try {
            return new MessageDigestOutputStream(MessageDigest.getInstance(algo));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static MessageDigestOutputStream md2() {
        return MessageDigestOutputStream.output("md2");
    }

    public static MessageDigestOutputStream md5() {
        return MessageDigestOutputStream.output("md5");
    }

    public static MessageDigestOutputStream sha1() {
        return MessageDigestOutputStream.output("sha-1");
    }

    public static MessageDigestOutputStream sha256() {
        return MessageDigestOutputStream.output("sha-256");
    }

    public static MessageDigestOutputStream sha384() {
        return MessageDigestOutputStream.output("sha-384");
    }

    public static MessageDigestOutputStream sha512() {
        return MessageDigestOutputStream.output("sha-512");
    }
}

