/*
 * Decompiled with CFR 0.152.
 */
package gs.hitchin.hitchfs;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import gs.hitchin.hitchfs.FileProp;
import java.util.Map;

public class PropStore {
    Map<Class<? extends FileProp>, FileProp> props = Maps.newHashMap();

    public PropStore withProperty(FileProp property) {
        Preconditions.checkNotNull((Object)property);
        this.props.put(property.getClass(), property);
        return this;
    }

    public <T extends FileProp> PropStore withProperty(Class<T> type, T value) {
        Preconditions.checkNotNull(type);
        this.props.put(type, value);
        return this;
    }

    public <T extends FileProp> T getProperty(Class<T> prop) {
        return (T)this.props.get(prop);
    }

    public boolean hasProperty(Class<?> type) {
        return this.props.containsKey(type);
    }

    public <P extends FileProp, S> S visitProperty(Class<P> type, PropVisitor<P, S> visitor) {
        P p = this.getProperty(type);
        if (p != null) {
            return visitor.some(p);
        }
        return visitor.none(this);
    }

    public Map<Class<? extends FileProp>, FileProp> getMap() {
        return this.props;
    }

    public Map<Class<? extends FileProp>, FileProp> setMap(Map<Class<? extends FileProp>, FileProp> props) {
        Map<Class<? extends FileProp>, FileProp> old = this.props;
        this.props = props;
        return old;
    }

    public static interface PropVisitor<P, S> {
        public S some(P var1);

        public S none(PropStore var1);
    }
}

