/*
 * Decompiled with CFR 0.152.
 */
package gs.hitchin.hitchfs;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import gs.hitchin.hitchfs.FakeFile;
import gs.hitchin.hitchfs.FakeFileOperations;
import gs.hitchin.hitchfs.FileSystem;
import gs.hitchin.hitchfs.StubFakeFileOperations;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedList;

public class StubFileSystem
extends StubFakeFileOperations
implements FileSystem {
    String separator = File.separator;
    char separatorChar = File.separatorChar;
    String pathSeparator = File.pathSeparator;
    char pathSeparatorChar = File.pathSeparatorChar;
    boolean caseSensitive = this.separatorChar == '/';
    FakeFileOperations operations = this;

    public StubFileSystem() {
    }

    public StubFileSystem(FakeFileOperations operations) {
        this.operations = operations;
    }

    public FakeFile file(File parent, String child) {
        return this.update(new FakeFile(this.getFileOperations(), parent, child));
    }

    public FakeFile file(String parent, String child) {
        return this.update(new FakeFile(this.getFileOperations(), parent, child));
    }

    public FakeFile file(String pathname) {
        return this.update(new FakeFile(this.getFileOperations(), pathname));
    }

    public FakeFile file(URI uri) {
        return this.update(new FakeFile(this.getFileOperations(), uri));
    }

    public FakeFile file(File regular) {
        if (regular instanceof FakeFile) {
            return this.update((FakeFile)regular);
        }
        return this.update(new FakeFile(this.getFileOperations(), regular));
    }

    public FakeFileOperations getFileOperations() {
        return this.operations;
    }

    public FakeFile update(FakeFile file) {
        return this.register(file.setKey(this.canonical(file.getPathField())));
    }

    public FakeFile register(FakeFile file) {
        return file;
    }

    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public String getCurrentDirectory() {
        return System.getProperty("user.dir");
    }

    public Iterable<String> getCurrentDirectorySplit() {
        return Iterables.skip(Arrays.asList(this.getCurrentDirectory().split("/")), (int)1);
    }

    public boolean isAbsolute(String path) {
        if (this.getSeparatorChar() == '\\') {
            if (path.length() > 1 && path.charAt(0) == this.getSeparatorChar() && path.charAt(1) == this.getSeparatorChar()) {
                return true;
            }
            return path.length() > 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' && (path.charAt(2) == '/' || path.charAt(2) == '\\');
        }
        return path.length() > 0 && path.charAt(0) == this.getSeparatorChar();
    }

    @Override
    public String getSeparator() {
        return this.separator;
    }

    @Override
    public char getSeparatorChar() {
        return this.separatorChar;
    }

    @Override
    public String getPathSeparator() {
        return this.pathSeparator;
    }

    @Override
    public char getPathSeparatorChar() {
        return this.pathSeparatorChar;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public Iterable<String> absoluteSplit(String path) {
        LinkedList ps = Lists.newLinkedList();
        if (!this.isAbsolute(path)) {
            for (String p : this.getCurrentDirectorySplit()) {
                ps.addLast(p);
            }
        }
        for (String p : path.split(this.getSeparator())) {
            if ("".equals(p)) continue;
            ps.addLast(p);
        }
        return ps;
    }

    public String absolute(String path) {
        return StubFileSystem.makePath(this.absoluteSplit(path), this.getSeparator(), true);
    }

    public Iterable<String> canonicalSplit(String path) {
        LinkedList ps = Lists.newLinkedList();
        if (!path.startsWith(this.getSeparator())) {
            for (String p : this.getCurrentDirectorySplit()) {
                ps.addLast(p);
            }
        }
        for (String p : path.split(this.getSeparator())) {
            if ("..".equals(p)) {
                if (ps.size() <= 0) continue;
                ps.removeLast();
                continue;
            }
            if (".".equals(p) || "".equals(p)) continue;
            ps.addLast(p);
        }
        return ps;
    }

    public String canonical(String path) {
        return StubFileSystem.makePath(this.canonicalSplit(path), this.getSeparator(), true);
    }

    public static String makePath(Iterable<String> ps, String pathDelim, boolean absolute) {
        StringBuilder buffer = new StringBuilder();
        if (absolute) {
            buffer.append(pathDelim);
        }
        Joiner.on((String)pathDelim).appendTo(buffer, ps);
        return buffer.toString();
    }

    public File createTempFile(String suffix, String prefix) throws IOException {
        throw new UnsupportedOperationException();
    }

    public File createTempFile(String suffix, String prefix, File directory) throws IOException {
        throw new UnsupportedOperationException();
    }

    public File[] listRoots() {
        throw new UnsupportedOperationException();
    }

    public InputStream input(File file) throws IOException {
        return this.getInputStream(this.file(file));
    }

    public InputStream input(String file) throws IOException {
        return this.input(this.file(file));
    }

    public OutputStream output(File file) throws IOException {
        return this.output(file, false);
    }

    public OutputStream output(String filename) throws IOException {
        return this.output(this.file(filename));
    }

    public OutputStream output(File file, boolean append) throws IOException {
        return this.getOutputStream(this.file(file), append);
    }

    public OutputStream output(String filename, boolean append) throws IOException {
        return this.output(this.file(filename), append);
    }

    public Reader reader(File file) throws IOException {
        return new InputStreamReader(this.input(file));
    }

    public Reader reader(String filename) throws IOException {
        return this.reader(this.file(filename));
    }

    public Writer writer(File file) throws IOException {
        return this.writer(file, false);
    }

    public Writer writer(String filename) throws IOException {
        return this.writer(this.file(filename));
    }

    public Writer writer(File file, boolean append) throws IOException {
        return new OutputStreamWriter(this.output(file, append));
    }

    public Writer writer(String filename, boolean append) throws IOException {
        return this.writer(this.file(filename), append);
    }

    public InputStream input(FileDescriptor fdObj) {
        throw new UnsupportedOperationException();
    }

    public OutputStream output(FileDescriptor fdObj) {
        throw new UnsupportedOperationException();
    }

    public Reader reader(FileDescriptor fdObj) {
        throw new UnsupportedOperationException();
    }

    public Writer writer(FileDescriptor fdObj) {
        throw new UnsupportedOperationException();
    }
}

