/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.throwingproviders;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.internal.Preconditions;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.throwingproviders.ThrowingProvider;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowingProviderBinder {
    private final Binder binder;

    private ThrowingProviderBinder(Binder binder) {
        this.binder = binder;
    }

    public static ThrowingProviderBinder create(Binder binder) {
        return new ThrowingProviderBinder(binder);
    }

    public <P extends ThrowingProvider> SecondaryBinder<P> bind(Class<P> interfaceType, Type valueType) {
        return new SecondaryBinder<P>(interfaceType, valueType);
    }

    private static class Result {
        private final Object value;
        private final Exception exception;

        private Result(Object value, Exception exception) {
            this.value = value;
            this.exception = exception;
        }

        public static Result forValue(Object value) {
            return new Result(value, null);
        }

        public static Result forException(Exception e) {
            return new Result(null, e);
        }

        public Object getOrThrow() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SecondaryBinder<P extends ThrowingProvider> {
        private final Class<P> interfaceType;
        private final Type valueType;
        private Class<? extends Annotation> annotationType;
        private Annotation annotation;
        private final Class<?> exceptionType;

        public SecondaryBinder(Class<P> interfaceType, Type valueType) {
            this.interfaceType = (Class)Preconditions.checkNotNull(interfaceType, (Object)"interfaceType");
            this.valueType = (Type)Preconditions.checkNotNull((Object)valueType, (Object)"valueType");
            this.checkInterface();
            this.exceptionType = this.getExceptionType(interfaceType);
        }

        public SecondaryBinder<P> annotatedWith(Class<? extends Annotation> annotationType) {
            if (this.annotationType != null || this.annotation != null) {
                throw new IllegalStateException();
            }
            this.annotationType = annotationType;
            return this;
        }

        public SecondaryBinder<P> annotatedWith(Annotation annotation) {
            if (this.annotationType != null || this.annotation != null) {
                throw new IllegalStateException();
            }
            this.annotation = annotation;
            return this;
        }

        public ScopedBindingBuilder to(P target) {
            Key targetKey = Key.get(this.interfaceType, (Annotation)UniqueAnnotations.create());
            ThrowingProviderBinder.this.binder.bind(targetKey).toInstance(target);
            return this.to(targetKey);
        }

        public ScopedBindingBuilder to(Class<? extends P> targetType) {
            return this.to(Key.get(targetType));
        }

        public ScopedBindingBuilder to(final Key<? extends P> targetKey) {
            Preconditions.checkNotNull(targetKey, (Object)"targetKey");
            final Key resultKey = Key.get(Result.class, (Annotation)UniqueAnnotations.create());
            Key<P> key = this.createKey();
            ThrowingProviderBinder.this.binder.bind(key).toProvider(new Provider<P>(){
                private P instance;

                @Inject
                void initialize(final Injector injector) {
                    this.instance = (ThrowingProvider)SecondaryBinder.this.interfaceType.cast(Proxy.newProxyInstance(SecondaryBinder.this.interfaceType.getClassLoader(), new Class[]{SecondaryBinder.this.interfaceType}, new InvocationHandler(){

                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            return ((Result)injector.getInstance(resultKey)).getOrThrow();
                        }
                    }));
                }

                public P get() {
                    return this.instance;
                }
            });
            return ThrowingProviderBinder.this.binder.bind(resultKey).toProvider((Provider)new Provider<Result>(){
                private Injector injector;

                @Inject
                void initialize(Injector injector) {
                    this.injector = injector;
                }

                public Result get() {
                    try {
                        return Result.forValue(((ThrowingProvider)this.injector.getInstance(targetKey)).get());
                    }
                    catch (Exception e) {
                        if (SecondaryBinder.this.exceptionType.isInstance(e)) {
                            return Result.forException(e);
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        private <P extends ThrowingProvider> Class<?> getExceptionType(Class<P> interfaceType) {
            ParameterizedType genericUnreliableProvider = (ParameterizedType)interfaceType.getGenericInterfaces()[0];
            return (Class)genericUnreliableProvider.getActualTypeArguments()[1];
        }

        private void checkInterface() {
            String errorMessage = "%s is not a compliant interface - see the Javadoc for ThrowingProvider";
            this.checkArgument(this.interfaceType.isInterface(), errorMessage, this.interfaceType.getName());
            this.checkArgument(this.interfaceType.getGenericInterfaces().length == 1, errorMessage, this.interfaceType.getName());
            this.checkArgument(this.interfaceType.getInterfaces()[0] == ThrowingProvider.class, errorMessage, this.interfaceType.getName());
            ParameterizedType genericThrowingProvider = (ParameterizedType)this.interfaceType.getGenericInterfaces()[0];
            if (this.interfaceType.getTypeParameters().length == 1) {
                this.checkArgument(this.interfaceType.getTypeParameters().length == 1, errorMessage, this.interfaceType.getName());
                String returnTypeName = this.interfaceType.getTypeParameters()[0].getName();
                Type returnType = genericThrowingProvider.getActualTypeArguments()[0];
                this.checkArgument(returnType instanceof TypeVariable, errorMessage, this.interfaceType.getName());
                this.checkArgument(returnTypeName.equals(((TypeVariable)returnType).getName()), errorMessage, this.interfaceType.getName());
            } else {
                this.checkArgument(this.interfaceType.getTypeParameters().length == 0, errorMessage, this.interfaceType.getName());
                this.checkArgument(genericThrowingProvider.getActualTypeArguments()[0].equals(this.valueType), errorMessage, this.interfaceType.getName());
            }
            Type exceptionType = genericThrowingProvider.getActualTypeArguments()[1];
            this.checkArgument(exceptionType instanceof Class, errorMessage, this.interfaceType.getName());
            if (this.interfaceType.getDeclaredMethods().length == 1) {
                Method method = this.interfaceType.getDeclaredMethods()[0];
                this.checkArgument(method.getName().equals("get"), errorMessage, this.interfaceType.getName());
                this.checkArgument(method.getParameterTypes().length == 0, errorMessage, this.interfaceType.getName());
            } else {
                this.checkArgument(this.interfaceType.getDeclaredMethods().length == 0, errorMessage, this.interfaceType.getName());
            }
        }

        private void checkArgument(boolean condition, String messageFormat, Object ... args) {
            if (!condition) {
                throw new IllegalArgumentException(String.format(messageFormat, args));
            }
        }

        private Key<P> createKey() {
            TypeLiteral typeLiteral;
            if (this.interfaceType.getTypeParameters().length == 1) {
                ParameterizedType type = Types.newParameterizedTypeWithOwner(this.interfaceType.getEnclosingClass(), this.interfaceType, (Type[])new Type[]{this.valueType});
                typeLiteral = TypeLiteral.get((Type)type);
            } else {
                typeLiteral = TypeLiteral.get(this.interfaceType);
            }
            if (this.annotation != null) {
                return Key.get((TypeLiteral)typeLiteral, (Annotation)this.annotation);
            }
            if (this.annotationType != null) {
                return Key.get((TypeLiteral)typeLiteral, this.annotationType);
            }
            return Key.get((TypeLiteral)typeLiteral);
        }
    }
}

