/*
 * Decompiled with CFR 0.152.
 */
package guru.breakthemonolith.health.mongodb;

import com.codahale.metrics.health.HealthCheck;
import com.mongodb.CommandResult;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoIterable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbHealthCheck
extends HealthCheck {
    private static Logger logger = LoggerFactory.getLogger(MongoDbHealthCheck.class);
    private String connectionUrl;
    private String databaseName;

    public MongoDbHealthCheck(String dbConnectionUrl, String dbName) {
        Validate.notBlank((CharSequence)dbConnectionUrl, (String)"Null or blank dbConnectionUrl not allowed.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dbName, (String)"Null or blank dbName not allowed.", (Object[])new Object[0]);
        this.connectionUrl = dbConnectionUrl;
        this.databaseName = dbName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HealthCheck.Result check() throws Exception {
        MongoClient mongoClient = null;
        String databaseList = null;
        String databaseStats = null;
        try {
            mongoClient = this.createMongoClient();
            MongoIterable dbList = mongoClient.listDatabaseNames();
            databaseList = StringUtils.join((Iterable)dbList, (char)',');
            CommandResult resultSet = mongoClient.getDB(this.databaseName).getStats();
            databaseStats = resultSet.toString();
            logger.debug("connectionUrl={} databaseList={} stats={}", new Object[]{this.connectionUrl, databaseList, databaseStats});
            Integer nbrCollections = (Integer)resultSet.get("collections");
            if (nbrCollections == 0) {
                throw new RuntimeException("Database has nothing in it.");
            }
        }
        catch (Exception e) {
            ContextedRuntimeException wrappedException = this.wrapException(e);
            wrappedException.addContextValue("databaseList", (Object)databaseList);
            wrappedException.addContextValue("databaseStats", databaseStats);
            logger.error("MongoDB Healthcheck Failure", (Throwable)wrappedException);
            HealthCheck.Result result = HealthCheck.Result.unhealthy((Throwable)wrappedException);
            return result;
        }
        finally {
            this.closeQuietly(mongoClient);
        }
        return HealthCheck.Result.healthy();
    }

    protected MongoClient createMongoClient() {
        return new MongoClient(this.connectionUrl);
    }

    private void closeQuietly(MongoClient mongoClient) {
        if (mongoClient != null) {
            try {
                mongoClient.close();
            }
            catch (Exception e) {
                ContextedRuntimeException wrappedException = this.wrapException(e);
                logger.warn("Error closing MongoDB client", (Throwable)wrappedException);
            }
        }
    }

    private ContextedRuntimeException wrapException(Exception e) {
        return new ContextedRuntimeException((Throwable)e).addContextValue("connectionUrl", (Object)this.connectionUrl).addContextValue("databaseName", (Object)this.databaseName);
    }
}

