/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.config;

import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.config.Location;
import guru.nidi.codeassert.config.LocationMatcher;
import java.util.ArrayList;
import java.util.List;

public class LocationNameMatcher {
    private final List<LocationMatcher> matchers = new ArrayList<LocationMatcher>();
    private final List<String> names;

    public LocationNameMatcher(List<Location> locs, List<String> names) {
        for (Location loc : locs) {
            this.matchers.add(new LocationMatcher(loc));
        }
        this.names = names;
    }

    public boolean matches(String name, Language lang, String className, String methodName, boolean strictNameMatch) {
        if (this.matchers.isEmpty()) {
            return this.matchesName(name, strictNameMatch);
        }
        for (LocationMatcher matcher : this.matchers) {
            if (!this.matches(matcher, name, lang, className, methodName, strictNameMatch)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(LocationMatcher matcher, String name, Language language, String className, String methodName, boolean strictNameMatch) {
        if (!this.matchesName(name, strictNameMatch) || !matcher.matchesLanguage(language)) {
            return false;
        }
        int pos = className.lastIndexOf(46);
        return pos < 0 ? matcher.matches("", className, methodName) : matcher.matches(className.substring(0, pos), className.substring(pos + 1), methodName);
    }

    private boolean matchesName(String name, boolean strictNameMatch) {
        if (this.names.isEmpty()) {
            return true;
        }
        for (String n : this.names) {
            if (!LocationMatcher.matchesPattern(this.createPattern(n, strictNameMatch), name)) continue;
            return true;
        }
        return false;
    }

    private String createPattern(String pattern, boolean strictPattern) {
        if (strictPattern) {
            return pattern;
        }
        String wildcarded = pattern;
        if (!pattern.startsWith("*")) {
            wildcarded = "*" + wildcarded;
        }
        if (!pattern.endsWith("*")) {
            wildcarded = wildcarded + "*";
        }
        return wildcarded;
    }

    public String toString() {
        return (this.names.isEmpty() ? "all" : this.names) + " in " + (this.matchers.isEmpty() ? "everywhere" : this.matchers);
    }
}

