/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.dependency;

import guru.nidi.codeassert.config.Location;
import guru.nidi.codeassert.config.LocationMatcher;
import guru.nidi.codeassert.dependency.DependencyRule;
import guru.nidi.codeassert.dependency.DependencyRules;
import guru.nidi.codeassert.model.UsingElement;
import guru.nidi.codeassert.model.UsingElementMatcher;

public class CodeElement
implements UsingElementMatcher {
    final LocationMatcher pattern;
    final boolean allowAll;

    CodeElement(String pattern, boolean allowAll) {
        int starPos = pattern.indexOf(42);
        int plusPos = pattern.indexOf(43);
        if (starPos >= 0 && starPos != pattern.length() - 1 || plusPos >= 0 && plusPos != pattern.length() - 1) {
            throw new IllegalArgumentException("Wildcards are allowed at the end (e.g. java.*)");
        }
        this.pattern = new LocationMatcher(Location.of(pattern));
        this.allowAll = allowAll;
    }

    public DependencyRule andAllSub() {
        return this.sub("*");
    }

    public DependencyRule allSubOf() {
        return this.sub("+");
    }

    public DependencyRule sub(String name) {
        String newPattern = this.pattern.toString() + (this.pattern.toString().endsWith(".") ? "" : ".") + name;
        return DependencyRules.addRuleToCurrent(new DependencyRule(newPattern, this.allowAll));
    }

    public DependencyRule rule() {
        String newPattern = this.pattern.toString();
        return DependencyRules.addRuleToCurrent(new DependencyRule(newPattern, this.allowAll));
    }

    @Override
    public boolean matches(UsingElement<?> elem) {
        return elem.isMatchedBy(this.pattern);
    }

    public String toString() {
        return "The java element " + this.pattern;
    }
}

