/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.dependency;

import guru.nidi.codeassert.config.LocationMatcher;
import guru.nidi.codeassert.dependency.DependencyMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class Dependencies {
    final DependencyMap allowed;
    final DependencyMap missing;
    final DependencyMap denied;
    final Set<LocationMatcher> notExisting;
    final Set<String> undefined;
    final Set<DependencyMap> cycles;

    public Dependencies() {
        this(new DependencyMap(), new DependencyMap(), new DependencyMap(), new TreeSet<LocationMatcher>(), new TreeSet<String>(), new HashSet<DependencyMap>());
    }

    public Dependencies(DependencyMap allowed, DependencyMap missing, DependencyMap denied, Set<LocationMatcher> notExisting, Set<String> undefined, Set<DependencyMap> cycles) {
        this.allowed = allowed;
        this.missing = missing;
        this.denied = denied;
        this.notExisting = notExisting;
        this.undefined = undefined;
        this.cycles = cycles;
    }

    public void merge(Dependencies cr) {
        this.allowed.merge(cr.allowed);
        this.missing.merge(cr.missing);
        this.denied.merge(cr.denied);
        this.notExisting.addAll(cr.notExisting);
        this.undefined.addAll(cr.undefined);
        this.cycles.addAll(cr.cycles);
    }

    public void normalize() {
        this.denied.without(this.allowed);
        this.allowed.clear();
    }

    public DependencyMap getAllowed() {
        return this.allowed;
    }

    public DependencyMap getMissing() {
        return this.missing;
    }

    public <T> List<String> getMissing(String from, Iterable<T> to, Function<T, String> toPack) {
        return this.missing.getDependencies(from).keySet().stream().filter(miss -> StreamSupport.stream(to.spliterator(), false).noneMatch(p -> ((String)toPack.apply(p)).equals(miss))).collect(Collectors.toList());
    }

    public DependencyMap getDenied() {
        return this.denied;
    }

    public Set<LocationMatcher> getNotExisting() {
        return this.notExisting;
    }

    public Set<String> getUndefined() {
        return this.undefined;
    }

    public Set<DependencyMap> getCycles() {
        return this.cycles;
    }

    public boolean isDenied(String from, String to) {
        return this.denied.getDependency(from, to) != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependencies that = (Dependencies)o;
        if (!this.allowed.equals(that.allowed)) {
            return false;
        }
        if (!this.missing.equals(that.missing)) {
            return false;
        }
        if (!this.denied.equals(that.denied)) {
            return false;
        }
        if (!this.notExisting.equals(that.notExisting)) {
            return false;
        }
        if (!this.undefined.equals(that.undefined)) {
            return false;
        }
        return this.cycles.equals(that.cycles);
    }

    public int hashCode() {
        int result = this.allowed.hashCode();
        result = 31 * result + this.missing.hashCode();
        result = 31 * result + this.denied.hashCode();
        result = 31 * result + this.notExisting.hashCode();
        result = 31 * result + this.undefined.hashCode();
        result = 31 * result + this.cycles.hashCode();
        return result;
    }

    public String toString() {
        return "RuleResult{allowed=" + this.allowed + ", missing=" + this.missing + ", denied=" + this.denied + ", notExisting=" + this.notExisting + ", undefined=" + this.undefined + ", cycles=" + this.cycles + '}';
    }
}

