/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.io;

import guru.nidi.codeassert.io.Visualized;
import guru.nidi.codeassert.model.CodePackage;
import guru.nidi.codeassert.model.Model;
import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Rank;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.model.CreationContext;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import java.util.function.Function;

public class ModelVisualizer {
    private final Model model;

    public ModelVisualizer(Model model) {
        this.model = model;
    }

    public Visualized visualizePackages(Function<CodePackage, MutableNode> transform) {
        MutableGraph graph = (MutableGraph)CreationContext.use(ctx -> {
            MutableGraph g = (MutableGraph)Factory.mutGraph().setDirected(true).graphAttrs().add((Attributes)Rank.dir((Rank.RankDir)Rank.RankDir.LEFT_TO_RIGHT));
            for (CodePackage pack : this.model.getPackages()) {
                g.add((LinkSource)transform.apply(pack));
            }
            return g;
        });
        return new Visualized(Graphviz.fromGraph((MutableGraph)graph));
    }

    public static Function<String, String> replaceFunc(String ... replacements) {
        if (replacements.length % 2 != 0) {
            throw new IllegalArgumentException("An even number of replacement parameters expected.");
        }
        return name -> {
            for (int i = 0; i < replacements.length; i += 2) {
                if (!name.startsWith(replacements[i])) continue;
                return replacements[i + 1] + name.substring(replacements[i].length());
            }
            return name;
        };
    }
}

