/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.jacoco;

import guru.nidi.codeassert.config.ValuedLocation;
import guru.nidi.codeassert.jacoco.CoverageType;
import guru.nidi.codeassert.jacoco.JacocoResult;
import guru.nidi.codeassert.util.ResultMatcher;
import java.util.List;
import org.hamcrest.Description;

public class CoverageMatcher
extends ResultMatcher<JacocoResult, ValuedLocation> {
    public void describeTo(Description description) {
        description.appendText("Has enough test coverage.");
    }

    protected void describeMismatchSafely(JacocoResult item, Description description) {
        description.appendText(String.format("Found unsatisfied test coverage requirements:%n", new Object[0]));
        description.appendText(this.pad("Analyzed coverage types:", 60));
        for (CoverageType type : item.getTypes()) {
            description.appendText(this.pad(type.toString(), 13));
        }
        for (ValuedLocation coverage : (List)item.findings()) {
            description.appendText(System.lineSeparator());
            this.printCoverage(coverage, description);
        }
    }

    private void printCoverage(ValuedLocation coverage, Description description) {
        description.appendText(this.pad(this.printLocation(coverage), 60));
        for (int i = 0; i < coverage.getValues().length; ++i) {
            description.appendText(String.format("%3.0f /%3s     ", coverage.getValues()[i], this.printAppliedValue(coverage.getAppliedLimits()[i])));
        }
    }

    private String printAppliedValue(double value) {
        return value == -1.0 ? " na" : String.format("%3.0f", value);
    }

    private String printLocation(ValuedLocation coverage) {
        if (coverage.getClazz().length() == 0) {
            if (coverage.getPack().length() == 0) {
                return "<global>";
            }
            return coverage.getPack();
        }
        return coverage.getPack() + "." + coverage.getClazz();
    }

    private String pad(String s, int len) {
        if (s.length() > len) {
            return s.substring(0, len);
        }
        StringBuilder p = new StringBuilder(s);
        while (p.length() < len) {
            p.append(' ');
        }
        return p.toString();
    }
}

