/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.model;

import guru.nidi.codeassert.model.CodeClass;
import guru.nidi.codeassert.model.MemberInfo;
import guru.nidi.codeassert.model.Model;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class InternalTypeInPublicApiMatcher
extends TypeSafeMatcher<Model> {
    private final Map<String, Map<String, List<String>>> findings = new HashMap<String, Map<String, List<String>>>();

    protected boolean matchesSafely(Model model) {
        for (CodeClass clazz : model.getClasses()) {
            if (!Modifier.isPublic(clazz.flags)) continue;
            this.checkMembers(model, clazz);
        }
        return this.findings.isEmpty();
    }

    private void checkMembers(Model model, CodeClass clazz) {
        for (MemberInfo member : clazz.getMembers()) {
            if (!Modifier.isPublic(member.getAccessFlags())) continue;
            for (String refClassName : member.referencedClasses) {
                CodeClass refClass = model.getOrCreateClass(refClassName);
                if (!refClass.isParsed() || Modifier.isPublic(refClass.flags)) continue;
                Map classFindings = this.findings.computeIfAbsent(clazz.getName(), s -> new HashMap());
                List memberFindings = classFindings.computeIfAbsent(member.getName(), s -> new ArrayList());
                memberFindings.add(refClass.getName());
            }
        }
    }

    public void describeTo(Description description) {
        description.appendText("Does not expose internal types in public APIs.");
    }

    protected void describeMismatchSafely(Model model, Description description) {
        description.appendText("Found these references to internal members in public APIs:\n");
        for (Map.Entry<String, Map<String, List<String>>> classFinding : this.findings.entrySet()) {
            description.appendText("In class " + classFinding.getKey() + "\n");
            for (Map.Entry<String, List<String>> memberFinding : classFinding.getValue().entrySet()) {
                description.appendText("  " + memberFinding.getKey() + ": " + memberFinding.getValue() + "\n");
            }
        }
    }
}

