/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.model;

import guru.nidi.codeassert.model.AttributeInfo;
import guru.nidi.codeassert.model.CodeClass;
import guru.nidi.codeassert.model.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class MemberInfo {
    private final int accessFlags;
    private final String name;
    final String descriptor;
    final AttributeInfo annotations;
    final String signature;
    final int codeSize;
    final Set<String> referencedClasses = new HashSet<String>();
    final Set<CodeClass> annotationClasses = new HashSet<CodeClass>();

    private MemberInfo(int accessFlags, String name, String descriptor, AttributeInfo annotations, String signature, int codeSize) {
        this.accessFlags = accessFlags;
        this.name = name;
        this.descriptor = descriptor;
        this.annotations = annotations;
        this.signature = signature;
        this.codeSize = codeSize;
    }

    static MemberInfo fromData(DataInputStream in, ConstantPool constantPool) throws IOException {
        int access = in.readUnsignedShort();
        String name = constantPool.getUtf8(in.readUnsignedShort());
        String descriptor = constantPool.getUtf8(in.readUnsignedShort());
        int attributesCount = in.readUnsignedShort();
        AttributeInfo annotations = null;
        String signature = null;
        int codeSize = 0;
        for (int a = 0; a < attributesCount; ++a) {
            AttributeInfo attribute = AttributeInfo.fromData(in, constantPool);
            if (attribute.isAnnotation()) {
                annotations = attribute;
            }
            if (attribute.isSignature()) {
                signature = constantPool.getUtf8(attribute.u2(0));
            }
            if (!attribute.isCode()) continue;
            codeSize = attribute.value.length;
        }
        return new MemberInfo(access, name, descriptor, annotations, signature, codeSize);
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public String getName() {
        return this.name;
    }

    public int getCodeSize() {
        return this.codeSize;
    }
}

