/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.model;

import guru.nidi.codeassert.model.CodeClass;
import guru.nidi.codeassert.model.MemberInfo;
import guru.nidi.codeassert.model.Model;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class PublicMemberInInternalTypeMatcher
extends TypeSafeMatcher<Model> {
    private final Map<String, List<String>> findings = new HashMap<String, List<String>>();

    protected boolean matchesSafely(Model model) {
        for (CodeClass clazz : model.getClasses()) {
            if (Modifier.isPublic(clazz.flags)) continue;
            this.checkMembers(clazz);
        }
        return this.findings.isEmpty();
    }

    private void checkMembers(CodeClass clazz) {
        for (MemberInfo member : clazz.getMembers()) {
            if (!Modifier.isPublic(member.getAccessFlags())) continue;
            List classFindings = this.findings.computeIfAbsent(clazz.getName(), s -> new ArrayList());
            classFindings.add(member.getName());
        }
    }

    public void describeTo(Description description) {
        description.appendText("Internal types have no public members.");
    }

    protected void describeMismatchSafely(Model model, Description description) {
        description.appendText("Found these public members in internal types:\n");
        for (Map.Entry<String, List<String>> classFinding : this.findings.entrySet()) {
            description.appendText(classFinding.getKey() + ": " + classFinding.getValue() + "\n");
        }
    }
}

