/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.model;

import guru.nidi.codeassert.AnalyzerException;
import guru.nidi.codeassert.config.LocationMatcher;
import guru.nidi.codeassert.model.CodeClass;
import guru.nidi.codeassert.model.CodePackage;
import guru.nidi.codeassert.model.Model;
import guru.nidi.codeassert.model.UsingElement;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Scope<T extends UsingElement<T>>
implements Iterable<T> {
    public static final Packages PACKAGES = new Packages(null);
    public static final Classes CLASSES = new Classes(null);
    protected final Model model;

    protected Scope(Model model) {
        this.model = model;
    }

    public static Scope<CodePackage> packages(Model model) {
        return new Packages(model);
    }

    public static Scope<CodeClass> classes(Model model) {
        return new Classes(model);
    }

    public Scope<T> in(Model model) {
        try {
            Constructor<?> c = this.getClass().getDeclaredConstructor(Model.class);
            return (Scope)c.newInstance(model);
        }
        catch (ReflectiveOperationException e) {
            throw new AnalyzerException("Could not create new Scope", e);
        }
    }

    public List<T> matchingElements(LocationMatcher matcher) {
        ArrayList<UsingElement> res = new ArrayList<UsingElement>();
        for (UsingElement elem : this) {
            if (!elem.isMatchedBy(matcher)) continue;
            res.add(elem);
        }
        return res;
    }

    public static class Classes
    extends Scope<CodeClass> {
        public Classes(Model model) {
            super(model);
        }

        @Override
        public Iterator<CodeClass> iterator() {
            return this.model.classes.values().iterator();
        }
    }

    public static class Packages
    extends Scope<CodePackage> {
        protected Packages(Model model) {
            super(model);
        }

        @Override
        public Iterator<CodePackage> iterator() {
            return this.model.packages.values().iterator();
        }
    }
}

