/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.model;

import guru.nidi.codeassert.AnalyzerException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

final class SignatureParser {
    private static final char EOF = '\uffff';
    private static final String NOT_IDENT = ".;[/<>:";
    private static final String BASE_TYPES = "BCDFIJSZ";
    private final String s;
    private char c;
    private int pos;
    private final Set<String> classes = new HashSet<String>();

    private SignatureParser(String s) {
        this.s = s;
        this.pos = 0;
        this.read();
    }

    static SignatureParser parseSignature(Source source, String signature) {
        SignatureParser parser = new SignatureParser(signature);
        switch (source) {
            case CLASS: {
                parser.classSignature();
                break;
            }
            case FIELD: {
                parser.fieldTypeSignature(false);
                break;
            }
            case METHOD: {
                parser.methodTypeSignature();
                break;
            }
        }
        return parser;
    }

    public Collection<String> getClasses() {
        return this.classes;
    }

    private void classSignature() {
        if (this.is('<')) {
            this.formalTypeParameters();
        }
        do {
            this.classTypeSignature();
        } while (!this.is('\uffff'));
    }

    private void formalTypeParameters() {
        this.read('<');
        do {
            this.formalTypeParameter();
        } while (!this.is('>'));
        this.read('>');
    }

    private void formalTypeParameter() {
        this.identifier();
        this.classBound();
        while (this.is(':')) {
            this.interfaceBound();
        }
    }

    private void classBound() {
        this.read(':');
        this.fieldTypeSignature(true);
    }

    private void interfaceBound() {
        this.read(':');
        this.fieldTypeSignature(false);
    }

    private void fieldTypeSignature(boolean opt) {
        if (!this.classTypeOrTypeVariableSignature()) {
            if (this.is('[')) {
                this.arrayTypeSignature();
            } else if (!opt) {
                throw new AnalyzerException("FieldTypeSignature expected [" + this.s + "]:" + this.pos);
            }
        }
    }

    private void classTypeSignature() {
        this.read('L');
        StringBuilder s = new StringBuilder();
        s.append(this.classIdentifier());
        while (!this.is(';') && !this.is('<')) {
            if (this.is('$')) {
                this.read();
                this.classIdentifier();
                continue;
            }
            s.append('.');
            this.read();
            s.append(this.classIdentifier());
        }
        String id = s.toString();
        if (this.is('<')) {
            this.typeArguments();
        }
        while (this.is('.')) {
            this.classTypeSignatureSuffix();
        }
        this.classes.add(id);
        this.read(';');
    }

    private void classTypeSignatureSuffix() {
        this.read('.');
        this.classIdentifier();
        if (this.is('<')) {
            this.typeArguments();
        }
    }

    private void typeArguments() {
        this.read('<');
        do {
            this.typeArgument();
        } while (!this.is('>'));
        this.read('>');
    }

    private void typeArgument() {
        if (this.is('*')) {
            this.read('*');
        } else {
            if (this.is('+')) {
                this.read('+');
            } else if (this.is('-')) {
                this.read('-');
            }
            this.fieldTypeSignature(false);
        }
    }

    private void arrayTypeSignature() {
        this.read('[');
        this.typeSignature();
    }

    private void typeSignature() {
        if (this.isBaseType()) {
            this.read();
        } else {
            this.fieldTypeSignature(false);
        }
    }

    private boolean isBaseType() {
        return BASE_TYPES.indexOf(this.c) >= 0;
    }

    private void typeVariableSignature() {
        this.read('T');
        this.identifier();
        this.read(';');
    }

    private void methodTypeSignature() {
        if (this.is('<')) {
            this.formalTypeParameters();
        }
        this.read('(');
        while (!this.is(')')) {
            this.typeSignature();
        }
        this.read(')');
        this.returnType();
        while (this.is('^')) {
            this.throwsSignature();
        }
    }

    private void throwsSignature() {
        this.read('^');
        if (!this.classTypeOrTypeVariableSignature()) {
            throw new AnalyzerException("ClassType or TypeVariable signature expected [" + this.s + "]:" + this.pos);
        }
    }

    private boolean classTypeOrTypeVariableSignature() {
        if (this.is('L')) {
            this.classTypeSignature();
            return true;
        }
        if (this.is('T')) {
            this.typeVariableSignature();
            return true;
        }
        return false;
    }

    private void returnType() {
        if (this.is('V')) {
            this.read();
        } else {
            this.typeSignature();
        }
    }

    private String classIdentifier() {
        return this.identifier(true);
    }

    private String identifier() {
        return this.identifier(false);
    }

    private String identifier(boolean clazz) {
        StringBuilder s = new StringBuilder();
        do {
            s.append(this.c);
            this.read();
        } while (NOT_IDENT.indexOf(this.c) < 0 && (!clazz || this.c != '$'));
        return s.toString();
    }

    private boolean is(char ch) {
        return this.c == ch;
    }

    private char read() {
        char c = this.pos == this.s.length() ? (char)'\uffff' : this.s.charAt(this.pos++);
        this.c = c;
        return c;
    }

    private char read(char ch) {
        if (this.c != ch) {
            throw new AnalyzerException("'" + ch + "' expected in '" + this.s + "':" + this.pos);
        }
        return this.read();
    }

    public static enum Source {
        CLASS,
        FIELD,
        METHOD;

    }
}

