/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.config;

import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.config.ProjectLayout;
import guru.nidi.codeassert.util.ListUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;

public class AnalyzerConfig {
    private final EnumSet<Language> languages;
    private final List<Path> sources;
    private final List<Path> classes;

    public AnalyzerConfig() {
        this(EnumSet.of(Language.JAVA), Collections.emptyList(), Collections.emptyList());
    }

    public AnalyzerConfig(AnalyzerConfig config) {
        this(config.languages, config.sources, config.classes);
    }

    protected AnalyzerConfig(EnumSet<Language> languages, List<Path> sources, List<Path> classes) {
        this.languages = languages;
        this.sources = sources;
        this.classes = classes;
    }

    public AnalyzerConfig and(AnalyzerConfig config) {
        return new AnalyzerConfig(ListUtils.concat(this.languages, config.languages), ListUtils.concat(this.sources, config.sources), ListUtils.concat(this.classes, config.classes));
    }

    public static ProjectLayout.Maven maven(Language ... languages) {
        return AnalyzerConfig.maven(null, languages);
    }

    public static ProjectLayout.Maven maven(String module, Language ... languages) {
        return new ProjectLayout.Maven(module, languages);
    }

    public static ProjectLayout.Gradle gradle(Language ... languages) {
        return AnalyzerConfig.gradle(null, languages);
    }

    public static ProjectLayout.Gradle gradle(String module, Language ... languages) {
        return new ProjectLayout.Gradle(module, languages);
    }

    public AnalyzerConfig withSources(File basedir, String ... packages) {
        return new AnalyzerConfig(this.languages, ListUtils.concat(this.sources, Path.of(basedir, packages)), this.classes);
    }

    public AnalyzerConfig withClasses(File basedir, String ... packages) {
        return new AnalyzerConfig(this.languages, this.sources, ListUtils.concat(this.classes, Path.of(basedir, packages)));
    }

    public List<Path> getSourcePaths(Language ... languages) {
        return this.getPaths(this.sources, languages);
    }

    public List<Path> getClassPaths(Language ... languages) {
        return this.getPaths(this.classes, languages);
    }

    public List<File> getSources(Language ... languages) {
        return this.getFiles(this.sources, null, languages);
    }

    public List<File> getClasses(Language ... languages) {
        return this.getFiles(this.classes, ".class", languages);
    }

    private List<Path> getPaths(List<Path> paths, Language ... languages) {
        HashSet<Path> res = new HashSet<Path>();
        for (Language language : this.calcLanguages(languages)) {
            for (Path path : paths) {
                res.add(path.forLanguage(language));
            }
        }
        return new ArrayList<Path>(res);
    }

    private List<File> getFiles(List<Path> paths, String suffix, Language ... languages) {
        ArrayList<File> files = new ArrayList<File>();
        for (Language language : this.calcLanguages(languages)) {
            List<String> suff = suffix == null ? language.suffices : Collections.singletonList(suffix);
            for (Path path : paths) {
                this.crawlDir(new File(path.forLanguage(language).getPath()), suff, files);
            }
        }
        return files;
    }

    private EnumSet<Language> calcLanguages(Language ... languages) {
        EnumSet<Language> res = EnumSet.copyOf(this.languages);
        if (languages.length > 0) {
            res.retainAll(Arrays.asList(languages));
        }
        return res;
    }

    private void crawlDir(File base, List<String> suffices, List<File> res) {
        File[] files = base.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile() && this.hasAnySuffix(file.getName(), suffices)) {
                    res.add(file);
                }
                if (!file.isDirectory()) continue;
                this.crawlDir(file, suffices, res);
            }
        }
    }

    private boolean hasAnySuffix(String s, List<String> suffices) {
        for (String suffix : suffices) {
            if (!s.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static class Path {
        private final String base;
        private final String pack;

        public Path(String base, String pack) {
            this.base = base.endsWith("/") ? base.substring(0, base.length() - 1) : base;
            this.pack = pack.startsWith("/") ? pack.substring(1) : pack;
        }

        public static List<Path> of(File basedir, String ... packages) {
            ArrayList<Path> sources = new ArrayList<Path>();
            if (packages.length == 0) {
                sources.add(new Path(basedir.getPath().replace('\\', '/'), ""));
            } else {
                for (String pack : packages) {
                    sources.add(new Path(basedir.getPath().replace('\\', '/'), pack));
                }
            }
            return sources;
        }

        public Path forLanguage(Language language) {
            return new Path(this.base.replace("$language", language.path), this.pack);
        }

        public String getPath() {
            return this.base + (this.pack.length() == 0 ? "" : "/" + this.pack);
        }

        public String getBase() {
            return this.base;
        }

        public String getPack() {
            return this.pack;
        }

        public Path commonBase(Path path) {
            String[] thisParts = this.getPath().split("/");
            String[] otherParts = path.getPath().split("/");
            StringBuilder res = new StringBuilder();
            for (int i = 0; i < Math.min(thisParts.length, otherParts.length) && thisParts[i].equals(otherParts[i]); ++i) {
                res.append(thisParts[i]).append('/');
            }
            return res.length() < this.base.length() ? new Path(res.substring(0, res.length() - 1), "") : new Path(this.base, this.pack.substring(0, res.length() - this.base.length() - 2));
        }

        public static Path commonBase(Iterable<Path> paths) {
            Path base = null;
            for (Path path : paths) {
                base = base == null ? path : base.commonBase(path);
            }
            return base;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Path path = (Path)o;
            if (!this.base.equals(path.base)) {
                return false;
            }
            return this.pack.equals(path.pack);
        }

        public int hashCode() {
            int result = this.base.hashCode();
            result = 31 * result + this.pack.hashCode();
            return result;
        }

        public String toString() {
            return "Path(" + this.base + ", " + this.pack + ")";
        }
    }
}

