/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.config;

import guru.nidi.codeassert.config.Action;
import guru.nidi.codeassert.util.ListUtils;
import java.util.Arrays;
import java.util.List;

public final class CollectorConfig<A extends Action> {
    public final String reason;
    public final boolean ignoreUnused;
    public final List<A> actions;

    private CollectorConfig(String reason, boolean ignoreUnused, List<A> actions) {
        this.reason = reason;
        this.ignoreUnused = ignoreUnused;
        this.actions = actions;
    }

    public CollectorConfig<A> ignoringUnused() {
        return new CollectorConfig<A>(this.reason, true, this.actions);
    }

    @SafeVarargs
    public static <A extends Action> CollectorConfig<A> because(String reason, A ... actions) {
        return new CollectorConfig<A>(reason, false, Arrays.asList(actions));
    }

    @SafeVarargs
    public static <A extends Action> CollectorConfig<A> just(A ... actions) {
        return CollectorConfig.because(null, actions);
    }

    public String toString() {
        return ListUtils.andJoin((Object)("  " + (this.reason == null ? "just" : "because " + this.reason)), this.actions);
    }
}

