/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.config;

import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.config.Location;

public class LocationMatcher
implements Comparable<LocationMatcher> {
    private final Location loc;

    public LocationMatcher(Location location) {
        if (location == null) {
            throw new IllegalArgumentException("location must not be null");
        }
        this.loc = location;
    }

    public boolean matchesPackage(String packageName) {
        return LocationMatcher.matchesPattern(this.loc.pack, packageName) && this.matchesAll(this.loc.clazz) && this.matchesAll(this.loc.method);
    }

    public boolean matchesClass(String className) {
        int pos = className.lastIndexOf(46);
        return pos < 0 ? this.matchesAll(this.loc.method) && this.matchesAll(this.loc.pack) && this.matchesClassPattern(this.loc.clazz, className) : this.matchesPackageClass(className.substring(0, pos), className.substring(pos + 1));
    }

    public boolean matchesPackageClass(String packageName, String className) {
        return LocationMatcher.matchesPattern(this.loc.pack, packageName) && this.matchesClassPattern(this.loc.clazz, className) && this.matchesAll(this.loc.method);
    }

    public boolean matches(String packageName, String className, String methodName) {
        boolean matchesClass;
        boolean bl = matchesClass = this.matchesAll(this.loc.method) ? this.matchesClassPattern(this.loc.clazz, className) : LocationMatcher.matchesPattern(this.loc.clazz, className);
        return LocationMatcher.matchesPattern(this.loc.pack, packageName) && matchesClass && LocationMatcher.matchesPattern(this.loc.method, methodName == null ? "" : methodName);
    }

    public boolean matchesLanguage(Language language) {
        return language == null || this.loc.language == null || this.loc.language == language;
    }

    public int specificity() {
        return this.specificity(this.loc.pack) + this.specificity(this.loc.clazz) + this.specificity(this.loc.method);
    }

    private int specificity(String pattern) {
        if (this.matchesAll(pattern)) {
            return 1;
        }
        int s = 4;
        if (pattern.startsWith("*") || pattern.startsWith("+")) {
            --s;
        }
        if (pattern.endsWith("*") || pattern.endsWith("+")) {
            --s;
        }
        return s;
    }

    public String getPattern() {
        return this.loc.getPattern();
    }

    private boolean matchesAll(String pattern) {
        return pattern.length() == 0 || "*".equals(pattern);
    }

    private boolean matchesClassPattern(String pat, String name) {
        if (LocationMatcher.matchesPattern(pat, name)) {
            return true;
        }
        int pos = name.indexOf(36);
        if (pos >= 0) {
            return LocationMatcher.matchesPattern(pat, name.substring(0, pos));
        }
        return false;
    }

    static boolean matchesPattern(String pat, String name) {
        char end;
        if (pat.length() == 0 || "*".equals(pat) || "+".equals(pat) && name.length() > 0) {
            return true;
        }
        if (pat.endsWith(".*")) {
            return LocationMatcher.matchesPattern(pat.substring(0, pat.length() - 2), name) || LocationMatcher.matchesPattern(pat.substring(0, pat.length() - 1) + "+", name);
        }
        String pattern = pat;
        char start = pattern.charAt(0);
        if (start == '*' || start == '+') {
            pattern = pattern.substring(1);
        }
        if ((end = pattern.charAt(pattern.length() - 1)) == '*' || end == '+') {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        return LocationMatcher.doMatchesPattern(start, end, pattern, name);
    }

    private static boolean doMatchesPattern(char start, char end, String pat, String name) {
        boolean startOk;
        boolean endsWithPat;
        int pos = name.indexOf(pat);
        if (pos < 0) {
            return false;
        }
        boolean startsWithPat = pos == 0;
        boolean bl = endsWithPat = pos + pat.length() == name.length();
        boolean bl2 = start == '*' || start == '+' != startsWithPat ? true : (startOk = false);
        boolean endOk = end == '*' || end == '+' != endsWithPat;
        return startOk && endOk;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationMatcher that = (LocationMatcher)o;
        return this.loc.equals(that.loc);
    }

    public int hashCode() {
        return this.loc.hashCode();
    }

    public String toString() {
        return this.loc.toString();
    }

    @Override
    public int compareTo(LocationMatcher p) {
        return this.loc.compareTo(p.loc);
    }
}

