/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.config;

import guru.nidi.codeassert.config.AnalyzerConfig;
import guru.nidi.codeassert.config.Language;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;

public class ProjectLayout<T extends ProjectLayout> {
    private final List<String> modules;
    private final EnumSet<Language> languages;

    protected ProjectLayout(List<String> modules, EnumSet<Language> languages) {
        this.modules = new ArrayList<String>(modules);
        this.languages = languages;
    }

    protected ProjectLayout(List<String> modules, Language ... languages) {
        this(modules, languages.length == 0 ? EnumSet.of(Language.JAVA) : EnumSet.of(languages[0], languages));
    }

    public T modules(String ... modules) {
        if (this.modules.size() > 1 || this.modules.size() == 1 && this.modules.get(0) != null) {
            throw new IllegalStateException("You already defined modules.");
        }
        this.modules.clear();
        this.modules.addAll(Arrays.asList(modules));
        return (T)this;
    }

    public EnumSet<Language> getLanguages() {
        return this.languages;
    }

    protected List<AnalyzerConfig.Path> path(String[] packs, String ... paths) {
        ArrayList<AnalyzerConfig.Path> res = new ArrayList<AnalyzerConfig.Path>();
        for (String path : paths) {
            for (String normPath : this.paths(path)) {
                if (packs.length == 0) {
                    res.add(new AnalyzerConfig.Path(normPath, ""));
                    continue;
                }
                for (String pack : packs) {
                    String normPack = pack.replace('.', '/');
                    res.add(new AnalyzerConfig.Path(normPath, normPack));
                }
            }
        }
        return res;
    }

    private List<String> paths(String relative) {
        if (this.modules.isEmpty()) {
            return Collections.singletonList(relative);
        }
        return this.modules.stream().map(module -> module == null || module.length() == 0 || this.runningInModuleDir((String)module) ? relative : this.concat((String)module, relative)).collect(Collectors.toList());
    }

    private String concat(String path1, String path2) {
        return path1.endsWith("/") ? path1 + path2 : path1 + "/" + path2;
    }

    private boolean runningInModuleDir(String module) {
        return new File("").getAbsoluteFile().getName().equals(module);
    }

    public static class Gradle
    extends ProjectLayout<Gradle> {
        public Gradle(String module, Language ... languages) {
            super(Collections.singletonList(module), languages);
        }

        public AnalyzerConfig main(String ... packages) {
            return new AnalyzerConfig(this.getLanguages(), this.path(packages, "src/main/$language/"), this.path(packages, "build/classes/main/", "build/classes/$language/main/", "out/production/classes"));
        }

        public AnalyzerConfig test(String ... packages) {
            return new AnalyzerConfig(this.getLanguages(), this.path(packages, "src/test/$language/"), this.path(packages, "build/classes/test/", "build/classes/$language/test/", "out/test/classes"));
        }

        public AnalyzerConfig mainAndTest(String ... packages) {
            return this.main(packages).and(this.test(packages));
        }
    }

    public static class Maven
    extends ProjectLayout<Maven> {
        public Maven(String module, Language ... languages) {
            super(Collections.singletonList(module), languages);
        }

        public AnalyzerConfig main(String ... packages) {
            return new AnalyzerConfig(this.getLanguages(), this.path(packages, "src/main/$language/"), this.path(packages, "target/classes/"));
        }

        public AnalyzerConfig test(String ... packages) {
            return new AnalyzerConfig(this.getLanguages(), this.path(packages, "src/test/$language/"), this.path(packages, "target/test-classes/"));
        }

        public AnalyzerConfig mainAndTest(String ... packages) {
            return this.main(packages).and(this.test(packages));
        }
    }
}

