/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.model;

import guru.nidi.codeassert.model.AttributeInfo;
import guru.nidi.codeassert.model.CodeClass;
import guru.nidi.codeassert.model.CodeClassBuilder;
import guru.nidi.codeassert.model.ConstantPool;
import guru.nidi.codeassert.model.MemberInfo;
import guru.nidi.codeassert.model.Model;
import guru.nidi.codeassert.util.CountingInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

class ClassFileParser {
    private static final int JAVA_MAGIC = -889275714;
    private ConstantPool constantPool;
    private DataInputStream in;

    ClassFileParser() {
    }

    CodeClass parse(File file, Model model) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            CodeClass codeClass = this.parse(in, model);
            return codeClass;
        }
    }

    CodeClass parse(InputStream is, Model model) throws IOException {
        CountingInputStream counter = new CountingInputStream(is);
        this.in = new DataInputStream(counter);
        this.parseMagic();
        this.parseMinorVersion();
        this.parseMajorVersion();
        this.constantPool = ConstantPool.fromData(this.in);
        int flags = this.parseAccessFlags();
        String className = this.parseClassName();
        if (model.isIgnoreClass(className)) {
            return null;
        }
        String superClassName = this.parseSuperClassName();
        List<String> interfaceNames = this.parseInterfaces();
        List<MemberInfo> fields = this.parseMembers();
        List<MemberInfo> methods = this.parseMembers();
        List<AttributeInfo> attributes = this.parseAttributes();
        return new CodeClassBuilder((String)className, (Model)model, (ConstantPool)this.constantPool).addClassConstantReferences().addFlags((int)flags).addSuperClass((String)superClassName).addInterfaces(interfaceNames).addFieldRefs(fields).addMethodRefs(methods).addAttributeRefs(attributes).addPackageInfo((Model)model, (String)className).addCodeSizes((int)counter.getCount(), methods).clazz;
    }

    private int parseMagic() throws IOException {
        int magic = this.in.readInt();
        if (magic != -889275714) {
            throw new IOException("Invalid class file");
        }
        return magic;
    }

    private int parseMinorVersion() throws IOException {
        return this.in.readUnsignedShort();
    }

    private int parseMajorVersion() throws IOException {
        return this.in.readUnsignedShort();
    }

    private int parseAccessFlags() throws IOException {
        return this.in.readUnsignedShort();
    }

    private String parseClassName() throws IOException {
        int entryIndex = this.in.readUnsignedShort();
        return this.constantPool.getClassConstantName(entryIndex);
    }

    private String parseSuperClassName() throws IOException {
        int entryIndex = this.in.readUnsignedShort();
        return this.constantPool.getClassConstantName(entryIndex);
    }

    private List<String> parseInterfaces() throws IOException {
        int count = this.in.readUnsignedShort();
        ArrayList<String> names = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            int entryIndex = this.in.readUnsignedShort();
            names.add(this.constantPool.getClassConstantName(entryIndex));
        }
        return names;
    }

    private List<MemberInfo> parseMembers() throws IOException {
        int count = this.in.readUnsignedShort();
        ArrayList<MemberInfo> infos = new ArrayList<MemberInfo>(count);
        for (int i = 0; i < count; ++i) {
            infos.add(MemberInfo.fromData(this.in, this.constantPool));
        }
        return infos;
    }

    private List<AttributeInfo> parseAttributes() throws IOException {
        int count = this.in.readUnsignedShort();
        ArrayList<AttributeInfo> attributes = new ArrayList<AttributeInfo>(count);
        for (int i = 0; i < count; ++i) {
            attributes.add(AttributeInfo.fromData(this.in, this.constantPool));
        }
        return attributes;
    }
}

