/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.model;

import guru.nidi.codeassert.AnalyzerException;
import guru.nidi.codeassert.model.AttributeInfo;
import guru.nidi.codeassert.model.CodeClass;
import guru.nidi.codeassert.model.CodePackage;
import guru.nidi.codeassert.model.Constant;
import guru.nidi.codeassert.model.ConstantPool;
import guru.nidi.codeassert.model.MemberInfo;
import guru.nidi.codeassert.model.Model;
import guru.nidi.codeassert.model.SignatureParser;
import java.io.IOException;
import java.util.List;

class CodeClassBuilder {
    private static final char CLASS_DESCRIPTOR = 'L';
    private static final char TYPE_END = ';';
    final CodeClass clazz;
    private final Model model;
    private final ConstantPool constantPool;

    private CodeClassBuilder(CodeClass clazz, Model model, ConstantPool constantPool) {
        this.clazz = clazz;
        this.model = model;
        this.constantPool = constantPool;
    }

    CodeClassBuilder(String className, Model model, ConstantPool constantPool) {
        this(model.getOrCreateClass(className), model, constantPool);
    }

    CodeClassBuilder(CodeClass clazz) {
        this(clazz, null, null);
    }

    CodeClassBuilder addSuperClass(String className) {
        this.clazz.superClass = className;
        this.addImport(className);
        return this;
    }

    CodeClassBuilder addInterfaces(List<String> interfaceNames) {
        for (String interfaceName : interfaceNames) {
            this.addImport(interfaceName);
        }
        return this;
    }

    CodeClassBuilder addClassConstantReferences() throws IOException {
        for (Constant constant : this.constantPool) {
            if (constant.tag != 7) continue;
            String name = this.constantPool.getUtf8(constant.nameIndex);
            this.addImport(name);
        }
        return this;
    }

    CodeClassBuilder addFlags(int flags) {
        this.clazz.flags = flags;
        return this;
    }

    CodeClassBuilder addMethodRefs(List<MemberInfo> methods) throws IOException {
        this.addMemberAnnotationRefs(methods);
        this.addMemberSignatureRefs(SignatureParser.Source.METHOD, methods);
        this.addMemberTypes(methods);
        this.clazz.methods.addAll(methods);
        return this;
    }

    CodeClassBuilder addFieldRefs(List<MemberInfo> fields) throws IOException {
        this.addMemberAnnotationRefs(fields);
        this.addMemberSignatureRefs(SignatureParser.Source.FIELD, fields);
        this.addMemberTypes(fields);
        this.clazz.fields.addAll(fields);
        return this;
    }

    CodeClassBuilder addAttributeRefs(List<AttributeInfo> attributes) throws IOException {
        for (AttributeInfo attribute : attributes) {
            this.addSourceAttribute(attribute);
            this.addAttributeAnnotationRefs(attribute);
            this.addAttributeSignatureRefs(attribute);
        }
        return this;
    }

    CodeClassBuilder addPackageInfo(Model model, String className) {
        if (className.endsWith(".package-info")) {
            CodePackage pack = model.getOrCreatePackage(model.packageOf(className));
            for (CodeClass ann : this.clazz.getAnnotations()) {
                pack.addAnnotation(ann);
            }
        }
        return this;
    }

    CodeClassBuilder addCodeSizes(int totalSize, List<MemberInfo> methods) {
        int codeSize = 0;
        for (MemberInfo method : methods) {
            codeSize += method.codeSize;
        }
        this.clazz.codeSize = codeSize;
        this.clazz.totalSize = totalSize;
        return this;
    }

    CodeClassBuilder addSourceSizes(int sourceSize, int codeLines, int commentLines, int emptyLines, int totalLines) {
        this.clazz.sourceSize = sourceSize;
        this.clazz.codeLines = codeLines;
        this.clazz.commentLines = commentLines;
        this.clazz.emptyLines = emptyLines;
        this.clazz.totalLines = totalLines;
        return this;
    }

    private void addMemberAnnotationRefs(List<MemberInfo> members) throws IOException {
        for (MemberInfo member : members) {
            if (member.annotations == null) continue;
            this.addAnnotationReferences(member.annotations, member);
        }
    }

    private void addMemberSignatureRefs(SignatureParser.Source source, List<MemberInfo> members) throws IOException {
        for (MemberInfo member : members) {
            if (member.signature == null) continue;
            for (String clazz : SignatureParser.parseSignature(source, member.signature).getClasses()) {
                this.addMemberClassRef(member, clazz);
                this.addImport(clazz);
            }
        }
    }

    private void addMemberTypes(List<MemberInfo> members) {
        for (MemberInfo member : members) {
            String[] types;
            for (String type : types = this.descriptorToTypes(member.descriptor)) {
                if (type.length() <= 0) continue;
                this.addMemberClassRef(member, type);
                this.addImport(type);
            }
        }
    }

    private void addSourceAttribute(AttributeInfo attribute) throws IOException {
        if (attribute.isSource()) {
            this.clazz.sourceFile = attribute.sourceFile(this.constantPool);
        }
    }

    private void addAttributeSignatureRefs(AttributeInfo attribute) throws IOException {
        if (attribute.isSignature()) {
            String name = this.constantPool.getUtf8(attribute.u2(0));
            for (String clazz : SignatureParser.parseSignature(SignatureParser.Source.CLASS, name).getClasses()) {
                this.addImport(clazz);
            }
        }
    }

    private void addAttributeAnnotationRefs(AttributeInfo attribute) throws IOException {
        if (attribute.isAnnotation()) {
            this.addAnnotationReferences(attribute, null);
        }
    }

    private void addAnnotationReferences(AttributeInfo annotation, MemberInfo member) throws IOException {
        this.addAnnotationReferences(annotation, member, 2, annotation.u2(0));
    }

    private int addAnnotationReferences(AttributeInfo annotation, MemberInfo member, int index, int numAnnotations) throws IOException {
        int i = index;
        for (int a = 0; a < numAnnotations; ++a) {
            int typeIndex = annotation.u2(i);
            int elements = annotation.u2(i += 2);
            i += 2;
            String annType = this.getTypeName(this.descriptorToType(this.constantPool.getUtf8(typeIndex)));
            this.clazz.addAnnotation(annType, this.model, member == null ? this.clazz.getAnnotations() : member.annotationClasses);
            for (int e = 0; e < elements; ++e) {
                i = this.addAnnotationElementValueReferences(annotation, member, i + 2);
            }
        }
        return i;
    }

    private int addAnnotationElementValueReferences(AttributeInfo annotation, MemberInfo member, int i) throws IOException {
        byte tag = annotation.value[i];
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                return i + 3;
            }
            case 101: {
                this.addClassOrEnumRef(annotation, member, i);
                return i + 5;
            }
            case 99: {
                this.addClassOrEnumRef(annotation, member, i);
                return i + 3;
            }
            case 64: {
                return this.addAnnotationReferences(annotation, member, i + 1, 1);
            }
            case 91: {
                int numValues = annotation.u2(i + 1);
                int k = i + 3;
                for (int j = 0; j < numValues; ++j) {
                    k = this.addAnnotationElementValueReferences(annotation, member, k);
                }
                return k;
            }
        }
        throw new AnalyzerException("Unknown tag '" + tag + "'");
    }

    private void addClassOrEnumRef(AttributeInfo annotation, MemberInfo member, int i) throws IOException {
        int enumTypeIndex = annotation.u2(i + 1);
        String type = this.descriptorToType(this.constantPool.getUtf8(enumTypeIndex));
        this.addMemberClassRef(member, type);
        this.addImport(type);
    }

    private void addImport(String type) {
        String name = this.getTypeName(type);
        if (name != null) {
            this.clazz.addImport(name, this.model);
        }
    }

    private void addMemberClassRef(MemberInfo member, String type) {
        String name;
        if (member != null && (name = this.getTypeName(type)) != null) {
            member.referencedClasses.add(name);
        }
    }

    private String slashesToDots(String s) {
        return s.replace('/', '.');
    }

    private String getTypeName(String s) {
        String typed;
        if (s.length() > 0 && s.charAt(0) == '[') {
            String[] types = this.descriptorToTypes(s);
            if (types.length == 0) {
                return null;
            }
            typed = types[0];
        } else {
            typed = s;
        }
        return this.slashesToDots(typed);
    }

    private String descriptorToType(String descriptor) {
        if (!descriptor.startsWith("L")) {
            throw new AssertionError((Object)("Expected Object descriptor, but found '" + descriptor + "'"));
        }
        return descriptor.substring(1, descriptor.length() - 1);
    }

    private String[] descriptorToTypes(String descriptor) {
        int startIndex;
        int typesCount = 0;
        for (int i = 0; i < descriptor.length(); ++i) {
            if (descriptor.charAt(i) != ';') continue;
            ++typesCount;
        }
        String[] types = new String[typesCount];
        int typeIndex = 0;
        for (int index = 0; index < descriptor.length() && (startIndex = descriptor.indexOf(76, index)) >= 0; ++index) {
            index = descriptor.indexOf(59, startIndex + 1);
            types[typeIndex++] = descriptor.substring(startIndex + 1, index);
        }
        return types;
    }
}

