/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.detekt;

import guru.nidi.codeassert.detekt.DetektResult;
import guru.nidi.codeassert.detekt.TypedDetektFinding;
import guru.nidi.codeassert.util.ResultMatcher;
import io.gitlab.arturbosch.detekt.api.Location;
import java.io.File;
import java.util.List;
import org.hamcrest.Description;

public class DetektMatcher
extends ResultMatcher<DetektResult, TypedDetektFinding> {
    public void describeTo(Description description) {
        description.appendText("Has no detekt issues");
    }

    protected void describeMismatchSafely(DetektResult item, Description description) {
        for (TypedDetektFinding error : (List)item.findings()) {
            description.appendText(System.lineSeparator()).appendText(this.printError(error));
        }
    }

    private String printError(TypedDetektFinding finding) {
        Location location = finding.entity.getLocation();
        String path = new File(location.getFile()).getAbsolutePath();
        return String.format("%-15s %-15s %-30s %s:%d    %s", finding.severity, finding.type, finding.name, path, location.getSource().getLine(), finding.description);
    }
}

