/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.ktlint;

import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.RuleSet;
import com.pinterest.ktlint.core.RuleSetProvider;
import guru.nidi.codeassert.Analyzer;
import guru.nidi.codeassert.config.AnalyzerConfig;
import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.config.UsageCounter;
import guru.nidi.codeassert.ktlint.KtlintCollector;
import guru.nidi.codeassert.ktlint.KtlintResult;
import guru.nidi.codeassert.ktlint.LocatedLintError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KtlintAnalyzer
implements Analyzer<List<LocatedLintError>> {
    private static final Logger LOG = LoggerFactory.getLogger(KtlintAnalyzer.class);
    private static final Comparator<LocatedLintError> ERROR_COMPARATOR = Comparator.comparing(e -> e.ruleId).thenComparing(e -> e.line);
    private final AnalyzerConfig config;
    private final KtlintCollector collector;
    private final List<RuleSet> ruleSets;

    public KtlintAnalyzer(AnalyzerConfig config, KtlintCollector collector) {
        this(config, collector, Collections.emptyList());
    }

    private KtlintAnalyzer(AnalyzerConfig config, KtlintCollector collector, List<RuleSet> ruleSets) {
        this.config = config;
        this.collector = collector;
        this.ruleSets = ruleSets;
    }

    public KtlintAnalyzer withRuleSets(RuleSet ... ruleSets) {
        return new KtlintAnalyzer(this.config, this.collector, Arrays.asList(ruleSets));
    }

    public KtlintResult analyze() {
        ErrorListener listener = new ErrorListener();
        for (File src : this.config.getSources(new Language[]{Language.KOTLIN})) {
            try {
                listener.currentFile = src;
                KtLint.INSTANCE.lint(new KtLint.Params(src.getAbsolutePath(), this.readFile(src), this.findRuleSets(), Collections.emptyMap(), (Function2)listener, false, null, false));
            }
            catch (IOException e) {
                LOG.error("Could not read file {}", (Object)src, (Object)e);
            }
        }
        return this.createResult(listener);
    }

    private List<RuleSet> findRuleSets() {
        if (!this.ruleSets.isEmpty()) {
            return this.ruleSets;
        }
        ArrayList<RuleSet> res = new ArrayList<RuleSet>();
        for (RuleSetProvider provider : ServiceLoader.load(RuleSetProvider.class)) {
            RuleSet ruleSet = provider.get();
            if ("standard".equals(ruleSet.getId())) {
                res.add(0, ruleSet);
                continue;
            }
            res.add(ruleSet);
        }
        return res;
    }

    private String readFile(File f) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        return sb.toString();
    }

    private KtlintResult createResult(ErrorListener listener) {
        UsageCounter counter = new UsageCounter();
        List<LocatedLintError> errors = listener.errors.stream().filter(e -> counter.accept(this.collector.accept((LocatedLintError)e))).sorted(ERROR_COMPARATOR).collect(Collectors.toList());
        this.collector.printUnusedWarning(counter);
        return new KtlintResult(this, errors, this.collector.unusedActions(counter));
    }

    private static class ErrorListener
    implements Function2<LintError, Boolean, Unit> {
        final List<LocatedLintError> errors = new ArrayList<LocatedLintError>();
        File currentFile;

        private ErrorListener() {
        }

        public Unit invoke(LintError e, Boolean corrected) {
            this.errors.add(new LocatedLintError(this.currentFile, e.getLine(), e.getRuleId(), e.getDetail()));
            return null;
        }
    }
}

