/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.pmd;

import guru.nidi.codeassert.pmd.PmdRuleset;
import guru.nidi.codeassert.pmd.PropertyField;

public final class PmdRulesets {
    private PmdRulesets() {
    }

    public static PmdRuleset android() {
        return new PmdRuleset("rulesets/java/android.xml");
    }

    public static PmdRuleset basic() {
        return new PmdRuleset("rulesets/java/basic.xml");
    }

    public static PmdRuleset braces() {
        return new PmdRuleset("rulesets/java/braces.xml");
    }

    public static PmdRuleset cloning() {
        return new PmdRuleset("rulesets/java/clone.xml");
    }

    public static Codesize codesize() {
        return new Codesize();
    }

    public static Comments comments() {
        return new Comments();
    }

    public static PmdRuleset controversial() {
        return new PmdRuleset("rulesets/java/controversial.xml");
    }

    public static PmdRuleset coupling() {
        return new PmdRuleset("rulesets/java/coupling.xml");
    }

    public static PmdRuleset design() {
        return new PmdRuleset("rulesets/java/design.xml");
    }

    public static Empty empty() {
        return new Empty();
    }

    public static PmdRuleset finalizers() {
        return new PmdRuleset("rulesets/java/finalizers.xml");
    }

    public static PmdRuleset imports() {
        return new PmdRuleset("rulesets/java/imports.xml");
    }

    public static PmdRuleset j2ee() {
        return new PmdRuleset("rulesets/java/j2ee.xml");
    }

    public static PmdRuleset javabeans() {
        return new PmdRuleset("rulesets/java/javabeans.xml");
    }

    public static PmdRuleset junit() {
        return new PmdRuleset("rulesets/java/junit.xml");
    }

    public static Naming naming() {
        return new Naming();
    }

    public static PmdRuleset optimizations() {
        return new PmdRuleset("rulesets/java/optimizations.xml");
    }

    public static PmdRuleset exceptions() {
        return new PmdRuleset("rulesets/java/strictexception.xml");
    }

    public static PmdRuleset strings() {
        return new PmdRuleset("rulesets/java/strings.xml");
    }

    public static PmdRuleset sunSecure() {
        return new PmdRuleset("rulesets/java/sunsecure.xml");
    }

    public static PmdRuleset typeResolution() {
        return new PmdRuleset("rulesets/java/typeresolution.xml");
    }

    public static PmdRuleset unnecessary() {
        return new PmdRuleset("rulesets/java/unnecessary.xml");
    }

    public static PmdRuleset unused() {
        return new PmdRuleset("rulesets/java/unusedcode.xml");
    }

    public static class Naming
    extends PmdRuleset {
        @PropertyField(rule="ShortVariable", property="minimum")
        private Integer varMinLen;
        @PropertyField(rule="LongVariable", property="minimum")
        private Integer varMaxLen;
        @PropertyField(rule="ShortMethodName", property="minimum")
        private Integer methodMinLen;
        @PropertyField(rule="ShortClassName", property="minimum")
        private Integer classMinLen;

        public Naming() {
            super("rulesets/java/naming.xml");
        }

        public Naming variableLen(int min, int max) {
            this.varMinLen = min;
            this.varMaxLen = max;
            return this;
        }

        public Naming methodLen(int min) {
            this.methodMinLen = min;
            return this;
        }

        public Naming classLen(int min) {
            this.classMinLen = min;
            return this;
        }
    }

    public static class Comments
    extends PmdRuleset {
        @PropertyField(rule="CommentRequired", property="headerCommentRequirement")
        private Requirement header;
        @PropertyField(rule="CommentRequired", property="fieldCommentRequirement")
        private Requirement field;
        @PropertyField(rule="CommentRequired", property="publicMethodCommentRequirement")
        private Requirement publicMethod;
        @PropertyField(rule="CommentRequired", property="protectedMethodCommentRequirement")
        private Requirement protectedMethod;
        @PropertyField(rule="CommentRequired", property="enumCommentRequirement")
        private Requirement enums;
        @PropertyField(rule="CommentRequired", property="serialVersionUIDCommentRequired")
        private Requirement serialVersionUID;
        @PropertyField(rule="CommentSize", property="maxLines")
        private Integer maxLines;
        @PropertyField(rule="CommentSize", property="maxLineLength")
        private Integer maxLineLength;

        public Comments() {
            super("rulesets/java/comments.xml");
        }

        public Comments requirement(Requirement requirement) {
            this.header(requirement);
            this.field(requirement);
            this.publicMethod(requirement);
            this.protectedMethod(requirement);
            this.enums(requirement);
            this.serialVersionUID(requirement);
            return this;
        }

        public Comments header(Requirement requirement) {
            this.header = requirement;
            return this;
        }

        public Comments field(Requirement requirement) {
            this.field = requirement;
            return this;
        }

        public Comments publicMethod(Requirement requirement) {
            this.publicMethod = requirement;
            return this;
        }

        public Comments protectedMethod(Requirement requirement) {
            this.protectedMethod = requirement;
            return this;
        }

        public Comments enums(Requirement requirement) {
            this.enums = requirement;
            return this;
        }

        public Comments serialVersionUID(Requirement requirement) {
            this.serialVersionUID = requirement;
            return this;
        }

        public Comments maxLines(int lines) {
            this.maxLines = lines;
            return this;
        }

        public Comments maxLineLen(int maxLen) {
            this.maxLineLength = maxLen;
            return this;
        }

        public static enum Requirement {
            Required,
            Ignored,
            Unwanted;

        }
    }

    public static class Empty
    extends PmdRuleset {
        @PropertyField(rule="EmptyCatchBlock", property="allowCommentedBlocks")
        private Boolean allowCommented;

        public Empty() {
            super("rulesets/java/empty.xml");
        }

        public Empty allowCommentedEmptyCatch(boolean allow) {
            this.allowCommented = allow;
            return this;
        }
    }

    public static class Codesize
    extends PmdRuleset {
        @PropertyField(rule="ExcessiveMethodLength", property="minimum")
        private Double methodLength;
        @PropertyField(rule="TooManyMethods", property="maxmethods")
        private Integer methodCount;

        public Codesize() {
            super("rulesets/java/codesize.xml");
        }

        public Codesize excessiveMethodLength(int limit) {
            this.methodLength = limit;
            return this;
        }

        public Codesize tooManyMethods(int limit) {
            this.methodCount = limit;
            return this;
        }
    }
}

