/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.pmd;

import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.cpd.Mark;

final class PmdUtils {
    private PmdUtils() {
    }

    public static String className(Mark mark) {
        return PmdUtils.className(null, mark.getFilename());
    }

    public static String className(RuleViolation violation) {
        if (violation.getClassName().length() > 0) {
            return (violation.getPackageName().length() > 0 ? violation.getPackageName() + "." : "") + violation.getClassName();
        }
        return PmdUtils.className(violation.getPackageName(), violation.getFilename());
    }

    private static String className(String packageName, String rawFilename) {
        if (rawFilename.length() > 0) {
            String filename = rawFilename.replace('\\', '/');
            int last = filename.lastIndexOf(47);
            String prefix = "";
            if (packageName != null && packageName.length() > 0) {
                prefix = packageName + ".";
            } else {
                int java;
                int src = filename.indexOf("src/") + 3;
                int later = Math.max(src, java = filename.indexOf("java/") + 4);
                if (later >= 4) {
                    prefix = filename.substring(later + 1, last + 1).replace('/', '.');
                }
            }
            return prefix + filename.substring(last + 1, filename.length() - 5);
        }
        return "?";
    }
}

