/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.checkstyle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class StyleChecks {
    private static final String MAX_LINE_LEN = "maxLineLen";
    final String location;
    final Map<String, Object> params = new HashMap<String, Object>();

    private StyleChecks(String location, Object ... defaults) {
        this.location = location;
        for (int i = 0; i < defaults.length; i += 2) {
            this.params.put((String)defaults[i], defaults[i + 1]);
        }
    }

    public static StyleChecks from(String fileOrClasspath) {
        return new StyleChecks(fileOrClasspath, new Object[0]);
    }

    public static Google google() {
        return new Google();
    }

    public static Sun sun() {
        return new Sun();
    }

    protected <T extends StyleChecks> T withParam(String name, Object value) {
        this.params.put(name, value);
        return (T)this;
    }

    public static final class Sun
    extends StyleChecks {
        protected Sun() {
            super("/guru/nidi/codeassert/checkstyle/sun_checks.xml", new Object[]{StyleChecks.MAX_LINE_LEN, 80, "allowDefaultAccessMembers", false});
        }

        public Sun maxLineLen(int maxLineLen) {
            return (Sun)this.withParam(StyleChecks.MAX_LINE_LEN, maxLineLen);
        }

        public Sun allowDefaultAccessMembers(boolean allow) {
            return (Sun)this.withParam("allowDefaultAccessMembers", allow);
        }
    }

    public static final class Google
    extends StyleChecks {
        private static final String VARIABLE_PATTERN = "^[a-z][a-z0-9][a-zA-Z0-9]*$";

        protected Google() {
            super("/guru/nidi/codeassert/checkstyle/google_checks.xml", new Object[]{StyleChecks.MAX_LINE_LEN, 100, "indent-basicOffset", 2, "indent-case", 2, "indent-arrayInit", 2, "indent-throws", 4, "indent-lineWrapping", 4, "parameterName", VARIABLE_PATTERN, "catchParameterName", VARIABLE_PATTERN, "localVariableName", VARIABLE_PATTERN, "memberName", VARIABLE_PATTERN, "methodName", "^[a-z][a-z0-9][a-zA-Z0-9_]*$", "emptyLine-tokens", Arrays.asList(16, 30, 14, 15, 154, 12, 11, 9, 8, 10)});
        }

        public Google maxLineLen(int maxLineLen) {
            return (Google)this.withParam(StyleChecks.MAX_LINE_LEN, maxLineLen);
        }

        public Google indentBasic(int indentBasic) {
            return (Google)this.withParam("indent-basicOffset", indentBasic);
        }

        public Google indentCase(int indentCase) {
            return (Google)this.withParam("indent-case", indentCase);
        }

        public Google indentArrayInit(int indentArrayInit) {
            return (Google)this.withParam("indent-arrayInit", indentArrayInit);
        }

        public Google indentThrows(int indentThrows) {
            return (Google)this.withParam("indent-throws", indentThrows);
        }

        public Google indentLineWrapping(int indentLineWrapping) {
            return (Google)this.withParam("indent-lineWrapping", indentLineWrapping);
        }

        public Google paramName(String pattern) {
            return (Google)this.withParam("parameterName", pattern);
        }

        public Google catchParamName(String pattern) {
            return (Google)this.withParam("catchParameterName", pattern);
        }

        public Google localVarName(String pattern) {
            return (Google)this.withParam("localVariableName", pattern);
        }

        public Google memberName(String pattern) {
            return (Google)this.withParam("memberName", pattern);
        }

        public Google methodName(String pattern) {
            return (Google)this.withParam("methodName", pattern);
        }

        public Google emptyLineSeparatorTokens(int ... tokens) {
            ArrayList<Integer> ts = new ArrayList<Integer>();
            for (int token : tokens) {
                ts.add(token);
            }
            return (Google)this.withParam("emptyLine-tokens", ts);
        }
    }
}

