/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import guru.nidi.codeassert.config.ActionResult;
import guru.nidi.codeassert.config.BaseCollector;
import guru.nidi.codeassert.config.CollectorConfig;
import guru.nidi.codeassert.config.Ignore;
import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.config.NamedLocation;
import guru.nidi.codeassert.config.UsageCounter;
import guru.nidi.codeassert.util.ListUtils;
import java.util.List;

public class StyleEventCollector
extends BaseCollector<AuditEvent, Ignore, StyleEventCollector> {
    private final SeverityLevel severity;

    public StyleEventCollector() {
        this(null);
    }

    private StyleEventCollector(SeverityLevel severity) {
        this.severity = severity;
    }

    public StyleEventCollector severity(SeverityLevel severity) {
        return new StyleEventCollector(severity);
    }

    @SafeVarargs
    public final StyleEventCollector config(final CollectorConfig<Ignore> ... configs) {
        return new StyleEventCollector(this.severity){

            @Override
            public ActionResult accept(AuditEvent issue) {
                return this.accept(issue, StyleEventCollector.this, configs);
            }

            @Override
            public List<Ignore> unused(UsageCounter counter) {
                return this.unused(counter, StyleEventCollector.this, configs);
            }

            @Override
            public String toString() {
                return ListUtils.andJoin((Object)((Object)StyleEventCollector.this), (Object[])configs);
            }
        };
    }

    public ActionResult accept(AuditEvent issue) {
        return new ActionResult(this.severity == null || issue.getSeverityLevel().ordinal() >= this.severity.ordinal(), null, 1);
    }

    protected ActionResult doAccept(AuditEvent issue, Ignore action) {
        String className = this.guessClassFromFile(issue.getFileName(), Language.JAVA);
        String name = issue.getLocalizedMessage().getKey();
        return action.accept(new NamedLocation(name, Language.byFilename((String)issue.getFileName()), className, "", false));
    }

    public List<Ignore> unused(UsageCounter counter) {
        return this.unusedNullAction(counter, this.severity != null);
    }

    public String toString() {
        return this.severity == null ? "" : "Severity >= " + this.severity;
    }
}

