/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.pmd;

import guru.nidi.codeassert.Analyzer;
import guru.nidi.codeassert.AnalyzerException;
import guru.nidi.codeassert.config.AnalyzerConfig;
import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.config.UsageCounter;
import guru.nidi.codeassert.pmd.CpdMatchCollector;
import guru.nidi.codeassert.pmd.CpdResult;
import guru.nidi.codeassert.pmd.JavaUtilLoggerConfigurer;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.Match;

public class CpdAnalyzer
implements Analyzer<List<Match>> {
    private static final Comparator<Match> MATCH_SORTER;
    private final AnalyzerConfig config;
    private final int minTokens;
    private final CpdMatchCollector collector;

    public CpdAnalyzer(AnalyzerConfig config, int minTokens, CpdMatchCollector collector) {
        this.config = config;
        this.minTokens = minTokens;
        this.collector = collector;
    }

    public CpdResult analyze() {
        CPD cpd = this.createCpd();
        cpd.go();
        return this.processMatches(cpd.getMatches());
    }

    private CPD createCpd() {
        CPD cpd = new CPD(this.createCpdConfig());
        for (AnalyzerConfig.Path source : this.config.getSourcePaths(new Language[0])) {
            try {
                cpd.addRecursively(new File(source.getPath()));
            }
            catch (IOException e) {
                throw new AnalyzerException("Problem reading directory '" + source + "'", (Throwable)e);
            }
        }
        return cpd;
    }

    private CPDConfiguration createCpdConfig() {
        CPDConfiguration cpdConfig = new CPDConfiguration();
        cpdConfig.setMinimumTileSize(this.minTokens);
        cpdConfig.postContruct();
        return cpdConfig;
    }

    private CpdResult processMatches(Iterator<Match> matches) {
        UsageCounter counter = new UsageCounter();
        Iterable miter = () -> matches;
        List<Match> res = StreamSupport.stream(miter.spliterator(), false).filter(m -> counter.accept(this.collector.accept((Match)m))).sorted(MATCH_SORTER).collect(Collectors.toList());
        this.collector.printUnusedWarning(counter);
        return new CpdResult(this, res, this.collector.unusedActions(counter));
    }

    static {
        JavaUtilLoggerConfigurer.init();
        MATCH_SORTER = Comparator.comparingInt(Match::getTokenCount).reversed().thenComparing(m -> m.getFirstMark().getFilename());
    }
}

