/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.pmd;

import guru.nidi.codeassert.config.Action;
import guru.nidi.codeassert.config.CollectorTemplate;
import guru.nidi.codeassert.config.Ignore;
import guru.nidi.codeassert.config.In;
import guru.nidi.codeassert.pmd.CpdMatchCollector;
import guru.nidi.codeassert.pmd.PmdRuleset;
import guru.nidi.codeassert.pmd.PmdRulesets;
import guru.nidi.codeassert.pmd.PmdViolationCollector;

public final class PmdConfigs {
    private PmdConfigs() {
    }

    public static CollectorTemplate<Ignore> minimalPmdIgnore() {
        return (CollectorTemplate)((CollectorTemplate)((CollectorTemplate)((CollectorTemplate)CollectorTemplate.forA(PmdViolationCollector.class).because("junit", (Action[])new Ignore[]{In.classes((String[])new String[]{"*Test", "Test*"}).ignore(new String[]{"JUnitSpelling", "JUnitAssertionsShouldIncludeMessage", "AvoidDuplicateLiterals", "SignatureDeclareThrowsException", "TooManyStaticImports"})})).because("I don't agree", (Action[])new Ignore[]{In.everywhere().ignore(new String[]{"MethodArgumentCouldBeFinal", "AvoidFieldNameMatchingMethodName", "CommentDefaultAccessModifier", "AbstractNaming", "AvoidFieldNameMatchingTypeName", "UncommentedEmptyConstructor", "UseStringBufferForStringAppends", "UncommentedEmptyMethodBody", "EmptyMethodInAbstractClassShouldBeAbstract", "InefficientEmptyStringCheck"})})).because("it's equals", (Action[])new Ignore[]{In.methods((String[])new String[]{"equals"}).ignore(new String[]{"NPathComplexity", "ModifiedCyclomaticComplexity", "StdCyclomaticComplexity", "CyclomaticComplexity", "ConfusingTernary"})})).because("it's hashCode", (Action[])new Ignore[]{In.methods((String[])new String[]{"hashCode"}).ignore(new String[]{"ConfusingTernary"})});
    }

    public static CollectorTemplate<Ignore> dependencyTestIgnore(Class<?> dependencyTest) {
        return (CollectorTemplate)CollectorTemplate.of(Ignore.class).just((Action[])new Ignore[]{In.clazz(dependencyTest).ignore(new String[]{"AvoidDollarSigns", "VariableNamingConventions", "SuspiciousConstantFieldName"})});
    }

    public static CollectorTemplate<Ignore> cpdIgnoreEqualsHashCodeToString() {
        return (CollectorTemplate)CollectorTemplate.forA(CpdMatchCollector.class).because("equals, hashCode, toString sometimes look the same", (Action[])new Ignore[]{In.everywhere().ignore(new String[]{"public boolean equals(Object", "public int hashCode()", "public String toString()"})});
    }

    public static PmdRuleset[] defaultPmdRulesets() {
        return new PmdRuleset[]{PmdRulesets.basic(), PmdRulesets.braces(), PmdRulesets.comments().maxLines(35).maxLineLen(120).requirement(PmdRulesets.Comments.Requirement.Ignored), PmdRulesets.codesize().excessiveMethodLength(40).tooManyMethods(30), PmdRulesets.design(), PmdRulesets.empty().allowCommentedEmptyCatch(true), PmdRulesets.exceptions(), PmdRulesets.imports(), PmdRulesets.junit(), PmdRulesets.naming().variableLen(1, 25).methodLen(2), PmdRulesets.optimizations(), PmdRulesets.strings(), PmdRulesets.sunSecure(), PmdRulesets.typeResolution(), PmdRulesets.unnecessary(), PmdRulesets.unused()};
    }
}

