/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.ForNode;
import guru.nidi.graphviz.attribute.MapAttributes;
import guru.nidi.graphviz.attribute.NodeAttr;
import guru.nidi.graphviz.attribute.SingleAttributes;
import javax.annotation.Nullable;

public final class Shape
extends SingleAttributes<String, ForNode> {
    private static final String SHAPE = "shape";
    public static final Shape ELLIPSE = new Shape("ellipse");
    public static final Shape CIRCLE = new Shape("circle");
    public static final Shape POINT = new Shape("point");
    public static final Shape EGG = new Shape("egg");
    public static final Shape TRIANGLE = new Shape("triangle");
    public static final Shape DIAMOND = new Shape("diamond");
    public static final Shape TRAPEZIUM = new Shape("trapezium");
    public static final Shape PARALLELOGRAM = new Shape("parallelogram");
    public static final Shape HOUSE = new Shape("house");
    public static final Shape PENTAGON = new Shape("pentagon");
    public static final Shape HEXAGON = new Shape("hexagon");
    public static final Shape SEPTAGON = new Shape("septagon");
    public static final Shape OCTAGON = new Shape("octagon");
    public static final Shape DOUBLE_CIRCLE = new Shape("doublecircle");
    public static final Shape DOUBLE_OCTAGON = new Shape("doubleoctagon");
    public static final Shape TRIPLE_OCTAGON = new Shape("tripleoctagon");
    public static final Shape INV_TRIANGLE = new Shape("invtriangle");
    public static final Shape INV_TRAPEZIUM = new Shape("invtrapezium");
    public static final Shape INV_HOUSE = new Shape("invhouse");
    public static final Shape RECTANGLE = new Shape("rectangle");
    public static final Shape NONE = new Shape("none");

    private Shape(String value) {
        super(SHAPE, value);
    }

    public static Attributes<ForNode> mDiamond(String topLabel, String bottomLabel) {
        return Attributes.attrs(Attributes.attr(SHAPE, "Mdiamond"), Attributes.attr("toplabel", topLabel), Attributes.attr("bottomlabel", bottomLabel));
    }

    public static Attributes<ForNode> mSquare(String topLabel, String bottomLabel) {
        return Attributes.attrs(Attributes.attr(SHAPE, "Msquare"), Attributes.attr("toplabel", topLabel), Attributes.attr("bottomlabel", bottomLabel));
    }

    public static Attributes<ForNode> mCircle(String topLabel, String bottomLabel) {
        return Attributes.attrs(Attributes.attr(SHAPE, "Mcircle"), Attributes.attr("toplabel", topLabel), Attributes.attr("bottomlabel", bottomLabel));
    }

    public static Polygon polygon(int sides) {
        return new Polygon(sides, null, null, null);
    }

    public static class Polygon
    implements Attributes<ForNode> {
        private final int sides;
        @Nullable
        private final Double skew;
        @Nullable
        private final Double distortion;
        @Nullable
        private final Double rotation;

        Polygon(int sides, @Nullable Double skew, @Nullable Double distortion, @Nullable Double rotation) {
            this.sides = sides;
            this.skew = skew;
            this.distortion = distortion;
            this.rotation = rotation;
        }

        public Polygon skew(double skew) {
            return new Polygon(this.sides, skew, this.distortion, this.rotation);
        }

        public Polygon distortion(double distortion) {
            return new Polygon(this.sides, this.skew, distortion, this.rotation);
        }

        public Polygon rotation(double rotation) {
            return new Polygon(this.sides, this.skew, this.distortion, rotation);
        }

        @Override
        public Attributes<? super ForNode> applyTo(MapAttributes<? super ForNode> attrs) {
            NodeAttr.nodeAttr(Shape.SHAPE, "polygon").applyTo(attrs);
            NodeAttr.nodeAttr("sides", this.sides).applyTo(attrs);
            if (this.skew != null) {
                NodeAttr.nodeAttr("skew", this.skew).applyTo(attrs);
            }
            if (this.distortion != null) {
                NodeAttr.nodeAttr("distortion", this.distortion).applyTo(attrs);
            }
            if (this.rotation != null) {
                NodeAttr.nodeAttr("orientation", this.rotation).applyTo(attrs);
            }
            return attrs;
        }
    }
}

