/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.Engine;
import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.GraphvizCmdLineEngine;
import guru.nidi.graphviz.engine.GraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.GraphvizFilter;
import guru.nidi.graphviz.engine.GraphvizJdkEngine;
import guru.nidi.graphviz.engine.GraphvizServerEngine;
import guru.nidi.graphviz.engine.GraphvizV8Engine;
import guru.nidi.graphviz.engine.IoUtils;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.ProcessOptions;
import guru.nidi.graphviz.engine.Rasterizer;
import guru.nidi.graphviz.engine.Renderer;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.MutableGraph;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Graphviz {
    private static final Logger LOG = LoggerFactory.getLogger(Graphviz.class);
    private static final Pattern DPI_PATTERN = Pattern.compile("\"?dpi\"?\\s*=\\s*\"?([0-9.]+)\"?", 2);
    private static final List<GraphvizEngine> AVAILABLE_ENGINES = Graphviz.availableEngines();
    @Nullable
    private static volatile BlockingQueue<GraphvizEngine> engineQueue;
    @Nullable
    private static volatile GraphvizEngine engine;
    @Nullable
    private final MutableGraph graph;
    private final String src;
    @Nullable
    final Rasterizer rasterizer;
    final ProcessOptions processOptions;
    private final Options options;
    private final List<GraphvizFilter> filters;

    private Graphviz(@Nullable MutableGraph graph, String src) {
        this(graph, src, Rasterizer.DEFAULT, new ProcessOptions().dpi(Graphviz.dpi(src)), Options.create(), new ArrayList<GraphvizFilter>());
    }

    private Graphviz(@Nullable MutableGraph graph, String src, @Nullable Rasterizer rasterizer, ProcessOptions processOptions, Options options, List<GraphvizFilter> filters) {
        this.graph = graph;
        this.src = src;
        this.rasterizer = rasterizer;
        this.processOptions = processOptions;
        this.options = options;
        this.filters = filters;
    }

    private static List<GraphvizEngine> availableEngines() {
        ArrayList<GraphvizEngine> engines = new ArrayList<GraphvizEngine>();
        if (GraphvizCmdLineEngine.AVAILABLE) {
            engines.add(new GraphvizCmdLineEngine());
        }
        if (GraphvizV8Engine.AVAILABLE) {
            engines.add(new GraphvizV8Engine());
        }
        engines.add(new GraphvizServerEngine());
        if (GraphvizJdkEngine.AVAILABLE) {
            engines.add(new GraphvizJdkEngine());
        }
        if (engines.size() == 1) {
            LOG.warn("Only GraphvizServerEngine is available. If you want to use other engines, please put the needed dependencies on the classpath.");
        }
        return engines;
    }

    public static void useDefaultEngines() {
        Graphviz.useEngine(AVAILABLE_ENGINES);
    }

    public static void useEngine(GraphvizEngine first, GraphvizEngine ... rest) {
        ArrayList<GraphvizEngine> engines = new ArrayList<GraphvizEngine>();
        engines.add(first);
        engines.addAll(Arrays.asList(rest));
        Graphviz.useEngine(engines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void useEngine(List<GraphvizEngine> engines) {
        if (engines.isEmpty()) {
            Graphviz.useDefaultEngines();
            return;
        }
        Class<Graphviz> clazz = Graphviz.class;
        synchronized (Graphviz.class) {
            if (engineQueue == null) {
                engineQueue = new ArrayBlockingQueue<GraphvizEngine>(1);
            } else {
                try {
                    Graphviz.getEngine().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            engine = null;
            Graphviz.doUseEngine(engines);
            return;
        }
    }

    private static void doUseEngine(List<GraphvizEngine> engines) {
        if (engines.isEmpty()) {
            engineQueue.add(new ErrorGraphvizEngine());
        } else {
            engines.get(0).init(e -> engineQueue.add((GraphvizEngine)e), e -> Graphviz.doUseEngine(engines.subList(1, engines.size())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GraphvizEngine getEngine() {
        if (engineQueue == null) {
            Graphviz.useDefaultEngines();
        }
        Class<Graphviz> clazz = Graphviz.class;
        synchronized (Graphviz.class) {
            if (engine == null) {
                try {
                    engine = engineQueue.poll(120L, TimeUnit.SECONDS);
                    if (engine == null) {
                        throw new GraphvizException("Initializing graphviz engine took too long.");
                    }
                    if (engine instanceof ErrorGraphvizEngine) {
                        throw new GraphvizException("None of the provided engines could be initialized.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return engine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseEngine() {
        Class<Graphviz> clazz = Graphviz.class;
        synchronized (Graphviz.class) {
            if (engine != null) {
                Graphviz.doReleaseEngine(engine);
            }
            if (engineQueue != null) {
                for (GraphvizEngine engine : engineQueue) {
                    Graphviz.doReleaseEngine(engine);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            engine = null;
            engineQueue = null;
            return;
        }
    }

    private static void doReleaseEngine(GraphvizEngine engine) {
        try {
            engine.close();
        }
        catch (Exception e) {
            throw new GraphvizException("Problem closing engine", e);
        }
    }

    public static Graphviz fromFile(File src) throws IOException {
        try (FileInputStream in = new FileInputStream(src);){
            Graphviz graphviz = Graphviz.fromString(IoUtils.readStream(in)).basedir(src.getAbsoluteFile().getParentFile());
            return graphviz;
        }
    }

    public static Graphviz fromGraph(Graph graph) {
        return Graphviz.fromGraph((MutableGraph)((Object)graph));
    }

    public static Graphviz fromGraph(MutableGraph graph) {
        return new Graphviz(graph, graph.toString());
    }

    public static Graphviz fromString(String src) {
        return new Graphviz(null, src);
    }

    public Graphviz engine(Engine engine) {
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions, this.options.engine(engine), this.filters);
    }

    public Graphviz totalMemory(@Nullable Integer totalMemory) {
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions, this.options.totalMemory(totalMemory), this.filters);
    }

    public Graphviz yInvert(@Nullable Boolean yInvert) {
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions, this.options.yInvert(yInvert), this.filters);
    }

    public Graphviz basedir(File basedir) {
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions, this.options.basedir(basedir), this.filters);
    }

    public Graphviz width(int width) {
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions.width(width), this.options, this.filters);
    }

    public Graphviz height(int height) {
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions.height(height), this.options, this.filters);
    }

    public Graphviz scale(double scale) {
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions.scale(scale), this.options, this.filters);
    }

    public Graphviz filter(GraphvizFilter filter) {
        ArrayList<GraphvizFilter> fs = new ArrayList<GraphvizFilter>(this.filters);
        fs.add(filter);
        return new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions, this.options, fs);
    }

    public Renderer rasterize(@Nullable Rasterizer rasterizer) {
        if (rasterizer == null) {
            throw new IllegalArgumentException("The provided rasterizer implementation was not found. Make sure that either 'guru.nidi.com.kitfox:svgSalamander' or 'org.apache.xmlgraphics:batik-rasterizer' is available on the classpath.");
        }
        Options opts = this.options.format(rasterizer.format());
        Graphviz graphviz = new Graphviz(this.graph, this.src, rasterizer, this.processOptions, opts, this.filters);
        return new Renderer(graphviz, null, Format.PNG);
    }

    public Renderer render(Format format) {
        Graphviz g = new Graphviz(this.graph, this.src, this.rasterizer, this.processOptions, this.options.format(format), this.filters);
        return new Renderer(g, null, format);
    }

    EngineResult execute() {
        EngineResult result = this.options.format == Format.DOT ? EngineResult.fromString(this.src) : Graphviz.getEngine().execute(this.options.format.preProcess(this.src), this.options, this.rasterizer);
        EngineResult engineResult = this.options.format.postProcess(this, result);
        for (GraphvizFilter filter : this.filters) {
            engineResult = filter.filter(this.options.format, engineResult);
        }
        return engineResult;
    }

    Format format() {
        return this.options.format;
    }

    private static double dpi(String src) {
        Matcher matcher = DPI_PATTERN.matcher(src);
        return matcher.find() ? Double.parseDouble(matcher.group(1)) : 72.0;
    }

    private static class ErrorGraphvizEngine
    implements GraphvizEngine {
        private ErrorGraphvizEngine() {
        }

        @Override
        public void init(Consumer<GraphvizEngine> onOk, Consumer<GraphvizEngine> onError) {
        }

        @Override
        public EngineResult execute(String src, Options options, @Nullable Rasterizer rasterizer) {
            return EngineResult.fromString("");
        }

        @Override
        public void close() {
        }
    }
}

