/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

final class IoUtils {
    private IoUtils() {
    }

    static String readStream(InputStream in) throws IOException {
        int read;
        byte[] buf = new byte[in.available()];
        int total = 0;
        while ((read = in.read(buf, total, Math.min(100000, buf.length - total))) > 0) {
            total += read;
        }
        return new String(buf, StandardCharsets.UTF_8);
    }

    static boolean isOnClasspath(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource) != null;
    }

    static void closeQuietly(AutoCloseable c) {
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

