/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.AbstractJavascriptEngine;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.ResultHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;

class NashornJavascriptEngine
extends AbstractJavascriptEngine {
    private static final ScriptEngine ENGINE = new ScriptEngineManager().getEngineByExtension("js");
    private static final Pattern JAVA_18_PATTERN = Pattern.compile("1.8.0_(\\d+).*");
    private final ScriptContext context = new SimpleScriptContext();
    private final ResultHandler resultHandler = new ResultHandler();

    NashornJavascriptEngine() {
        String version = System.getProperty("java.version");
        Matcher matcher = JAVA_18_PATTERN.matcher(version);
        if (matcher.matches() && Integer.parseInt(matcher.group(1)) < 40) {
            throw new GraphvizException("You are using an old version of java 1.8. Please update it.");
        }
        this.context.getBindings(100).put("handler", (Object)this.resultHandler);
        this.eval("function result(r){ handler.setResult(r); }function error(r){ handler.setError(r); }");
    }

    @Override
    protected String execute(String js) {
        this.eval(js);
        return this.resultHandler.waitFor();
    }

    private void eval(String js) {
        try {
            ENGINE.eval(js, this.context);
        }
        catch (ScriptException e) {
            throw new GraphvizException("Problem executing javascript", e);
        }
    }
}

