/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.BatikRasterizer;
import guru.nidi.graphviz.engine.BuiltInRasterizer;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.IoUtils;
import guru.nidi.graphviz.engine.SalamanderRasterizer;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.LoggerFactory;

public interface Rasterizer {
    @Nullable
    public static final Rasterizer BATIK = IoUtils.isOnClasspath("org/apache/batik/transcoder/Transcoder.class") ? new BatikRasterizer() : null;
    @Nullable
    public static final Rasterizer SALAMANDER = IoUtils.isOnClasspath("com/kitfox/svg/SVGDiagram.class") ? new SalamanderRasterizer() : null;
    @Nullable
    public static final Rasterizer DEFAULT = Rasterizer.getDefault();

    @Nullable
    public static Rasterizer getDefault() {
        Rasterizer r;
        Rasterizer rasterizer = r = BATIK != null ? BATIK : SALAMANDER;
        if (r == null) {
            LoggerFactory.getLogger(Rasterizer.class).warn("Neither Batik nor Salamander found on classpath");
        }
        return r;
    }

    public static Rasterizer builtIn(String format) {
        return new BuiltInRasterizer(format, null, null);
    }

    public static Rasterizer builtIn(String format, String renderer) {
        return new BuiltInRasterizer(format, renderer, null);
    }

    public static Rasterizer builtIn(String format, String renderer, String formatter) {
        return new BuiltInRasterizer(format, renderer, formatter);
    }

    public Format format();

    public BufferedImage rasterize(Graphviz var1, @Nullable Consumer<Graphics2D> var2, String var3);
}

